/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * ForName.java
 *
 * Created on September 19, 2000, 1:39 PM
 */


package org.netbeans.test.java.integrity.ForName;

import junit.textui.TestRunner;
import org.netbeans.test.java.LogTestCase;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;

/** <B>Java Module Integrity API Test: ForName</B>
 * <BR><BR><I>What it tests:</I><BR>
 * Capability of module to search through mounted filesystems for specified Class.
 * <BR><BR><I>What has to be set:</I><BR>
 * testbase/testfs has to be mounted.
 * <BR><BR><I>How it works:</I><BR>
 * Test tries to find known classes using ClassElement.forName(ClassElement);
 * <BR><BR><I>Output:</I><BR>
 * Places, where were known classes found. This is compared with golden file.
 * <BR><BR><I>Possible reasons of failure:</I><BR>
 * <BR><BR><U>Some classes were not found</U><BR>
 * See .diff file which ones.
 * <BR><BR><U>Exception occured:</U><BR>
 * See .out or .diff file for StackTrace
 *
 * @author Jan Becicka <Jan.Becicka@sun.com>
 * @version
 */


public class ForName extends LogTestCase   {
    
    
    public void testRun(){
        try {
            FileObject artefact=FileUtil.toFileObject(classPathWorkDir);
            for (int i=0;i < Classes.length;i++){
                ClassElement ce = ClassElement.forName(Classes[i], artefact);
                if (ce == null){
                    ref(Classes[i]+" not found!");
                } else {
                    ref(Classes[i]+" found");// in "+ getFSName(ce));
                }
            }
        } catch (Exception e) {
            e.printStackTrace(log);
            assertTrue(e.toString(), false);
        }
    }
        
    public static void main(java.lang.String[] args) {
        TestRunner.run(ForName.class);
    }
    
    final String[] Classes = {
        "TopLevelClassDefaultPackage",
        "TopLevelClassDefaultPackage.InnerClass",
        "TopLevelClassDefaultPackage$InnerClass",
        "org.netbeans.test.java.testsources.TopLevelClass",
        "org.netbeans.test.java.testsources.TopLevelClass.InnerClass",
        "org.netbeans.test.java.testsources.TopLevelClass$InnerClass",
        "org.netbeans.test.java.testsources.InTestFS",
        "org.netbeans.test.java.testsources.InTestFS$InnerClass",
        "org.netbeans.test.java.testsources.InTestFS.InnerClass",
    };
    
    public ForName(java.lang.String testName) {
        super(testName);
    }
    
}
