/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * FieldElem.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.integrity.GetDeclaringClass;

import org.netbeans.test.java.Common;
import org.openide.src.*;
import java.lang.reflect.Modifier;
import org.netbeans.junit.*;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileUtil;

/** <B>Java Module Integrity API Test: GetDeclaringClass</B>
 * <BR><BR><I>What it tests:</I><BR>
 * getCeclaringClass should return declaring class of Element.
 * This test checks, if declaring class is always returned correctly.
 * Especially in cases, when Elements are moved from one class to another one, or if they are removed from class.
 * <BR><BR><I>How it works:</I><BR>
 * There is manipulated with Elements and after doing that is allways logged, what getDeclaringClass()'s returns.
 * <BR><BR><I>Output:</I><BR>
 * Log file produced by getDeclaringClass())
 * <BR><BR><I>Possible reasons of failure:</I><BR>
 * <BR><BR><U>getDeclaringClass has returned bad class</U><BR>
 * See .diff file which one.
 * <BR><BR><U>Exception occured:</U><BR>
 * See .out or .diff file for StackTrace
 *
 *
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */


public class GetDeclaringClass extends org.netbeans.test.java.LogTestCase {
    
    String name = "GetDeclaringClassTestTarget";
    String packageName = "org.netbeans.test.java.testsources";
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public GetDeclaringClass() {
        super("");
    }
    
    public GetDeclaringClass(java.lang.String testName) {
        super(testName);
    }
    
    public static NbTest suite() {
        return new NbTestSuite(GetDeclaringClass.class);
    }
    
    public void testRun() {
        try {
            _testIt();
        } catch (Exception e) {
            assertTrue(e.toString(), false);
        }
    }
    
    
    public void _testIt() throws Exception {
        
        org.openide.src.ClassElement clazz=null;
        boolean passed = true;
        try {
            clazz = Common.createClass(FileUtil.toFileObject(classPathWorkDir), packageName,name);
        } catch (Exception e) {
            e.printStackTrace(log);
            assertTrue(e.toString(), false);
        }
        
        ClassElement sourceClazz = ClassElement.forName("org.netbeans.test.java.testsources.GetDeclaringClassTest", FileUtil.toFileObject(classPathWorkDir));
        clazz.removeConstructors(clazz.getConstructors());
        
        clazz.addClass(sourceClazz.getClasses()[0]);
        ref(clazz.getClasses()[0].getDeclaringClass().getName().getFullName());
        
        clazz.addConstructor(sourceClazz.getConstructors()[0]);
        ref(clazz.getConstructors()[0].getDeclaringClass().getName().getFullName());
        
        clazz.addField(sourceClazz.getFields()[0]);
        ref(clazz.getFields()[0].getDeclaringClass().getName().getFullName());
        
        clazz.addInitializer(sourceClazz.getInitializers()[0]);
        ref(clazz.getInitializers()[0].getDeclaringClass().getName().getFullName());
        
        clazz.addMethod(sourceClazz.getMethods()[0]);
        ref(clazz.getMethods()[0].getDeclaringClass().getName().getFullName());
        
        MethodElement me = clazz.getMethods()[0];
        FieldElement fe = clazz.getFields()[0];
        InitializerElement ie = clazz.getInitializers()[0];
        ConstructorElement coe = clazz.getConstructors()[0];
        ClassElement ce = clazz.getClasses()[0];
        
        clazz.removeClass(ce);
        ref(ce.getDeclaringClass().getName().getFullName());
        
        clazz.removeConstructor(coe);
        ref(coe.getDeclaringClass().getName().getFullName());
        
        clazz.removeInitializer(ie);
        ref(ie.getDeclaringClass().getName().getFullName());
        
        clazz.removeMethod(me);
        ref(me.getDeclaringClass().getName().getFullName());
        
        clazz.removeField(fe);
        ref(me.getDeclaringClass().getName().getFullName());

        org.netbeans.modules.java.JavaDataObject DO = (org.netbeans.modules.java.JavaDataObject) clazz.getSource().getCookie(org.netbeans.modules.java.JavaDataObject.class);
        ((SaveCookie) DO.getCookie(SaveCookie.class)).save();
        DO.delete();

    }
}
