/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * ForName.java
 *
 * Created on September 19, 2000, 1:39 PM
 */

package org.netbeans.test.java.integrity.Identity;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;


/** <B>Java Module Integrity API Test: Identity</B>
 * <BR><BR><I>What it tests:</I><BR>
 * ClassElement.forName() should return the same class, no matter how many times you call it,
 * even if System.gc() is called between two calls of ClassElement.forName.
 * <BR><BR><I>How it works:</I><BR>
 * This test is only simple loop, which body has ClassElement.forName() and System.gc() calls.
 * Result from ClassElement.forName() is logged and then compared with golden file.
 * <BR><BR><I>Output:</I><BR>
 * Log file produced by ClassElelemnt.forName()
 * <BR><BR><I>Possible reasons of failure:</I><BR>
 * <BR><BR><U>Some call of forName returns bad class (or null)</U><BR>
 * See .diff file which one.
 * <BR><BR><U>Exception occured:</U><BR>
 * See .out or .diff file for StackTrace
 *
 * @author Jan Becicka <Jan.Becicka@sun.com>
 * @version
 */


public class Identity extends org.netbeans.test.java.LogTestCase   {
    
    
    public void testRun() {
        
        try {
            _testIt();
        } catch (Exception e) {
            assertTrue(e.toString(), false);
        }
    }
    
    public Identity(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(Identity.class);
    }
    
    static int LOOPCOUNT = 10;
    
    public void _testIt() throws Exception {
        FileObject artefact=FileUtil.toFileObject(classPathWorkDir);
        ClassElement ce = ClassElement.forName("org.netbeans.test.java.testsources.TopLevelClass$InnerClass", artefact);
        for (int i=0;i < LOOPCOUNT;i++){
            if (ce==ClassElement.forName("org.netbeans.test.java.testsources.TopLevelClass$InnerClass", artefact)){
                ref("forName returned right reference");
            } else {
                ref("forName returned wrong reference!");
            }
            System.gc();
            Thread.currentThread().sleep(i*500);
        }
        
    }
    
}
