/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * UnderPressure.java
 *
 * Created on August 2, 2000, 3:42 PM
 */

package org.netbeans.test.java.integrity.UnderPressure;

import org.openide.filesystems.*;
import org.openide.loaders.*;
import org.openide.cookies.SaveCookie;
import org.netbeans.test.java.*;

import org.openide.src.ClassElement;


   /** <B>Java Module General API Test: UnderPressure</B>
    * <BR><BR><I>What it tests:</I><BR>
    * Checks behavior, if module is overloaded.
    * Test is focused on monitoring of creating/deleting Elements.
    * <BR><BR><I>How it works:</I><BR>
    * Lots of classes are created/deleted using API.
    * This processes are logged to .out and compared with golden file
    * <BR><BR><I>Output:</I><BR>
    * Log of created/deleted classes.
    * <BR><BR><I>Possible reasons of failure:</I><BR>
    * <BR><BR><U>Some classes were not created or deleted properly</U><BR>
    * It's look like race condition, espacially if other tests passed.
    * <BR><BR><I>Exception occured:</I><BR>
    * See .out or .diff file for StackTrace
    *
    *
    * @author  Jan.Becicka@sun.com
    */

public class UnderPressure extends  org.netbeans.test.java.LogTestCase   {
    
    private static final String packageName = "org.netbeans.test.java.testsources";
    private static final String postPackageName = packageName + ".post";
    private static final String name="JavaTestSource";
    private static final String javaFileExtension="java";


    public UnderPressure(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(UnderPressure.class);
    }
    
    
    public void testRun() {
        
        Common.setPrintWriter(ref);
        try {
            java.util.Vector objects;
            for( int i=0; i<100; i++ ){
                objects = org.netbeans.test.java.Common.createObjects(packageName);
                writeObjects( objects );
                if( i%2==0 )
                    deleteObjects( objects );
            }
            FileObject fo=Repository.getDefault().find(postPackageName,"Department", "java");
            DataObject dob=DataObject.find(fo);
            dob.delete();
            fo=Repository.getDefault().find(postPackageName,"Employee", "java");
            dob=DataObject.find(fo);
            dob.delete();
            ref( "program terminated successfully" );
        }
        catch (Exception e){
            e.printStackTrace(log);
            assertTrue(e.getMessage(), false);
        }
        
    }
    
    public void writeObjects(java.util.Vector objects) throws Exception{
        ClassElement clazz;
        for (java.util.Iterator i=objects.iterator(); i.hasNext();){
            writeClassElement( (ClassElement) i.next() );
        }
        
    }
    
    public void deleteObjects(java.util.Vector objects) throws Exception{
        for( java.util.Iterator i=objects.iterator(); i.hasNext(); )
            deleteFileObject( (ClassElement) i.next() );
    }
    
    public void deleteFileObject(ClassElement clazz) throws Exception {
        String className=clazz.getName().getFullName();
        int index=className.lastIndexOf('.');
        String dirName=index==-1?"":className.substring(0, index).replace('.', '/');
        String fileName=index==-1?className:className.substring(index+1);
        org.openide.filesystems.Repository repository=Repository.getDefault();
        FileObject directory=repository.findResource(dirName);
        FileObject file;
        
        if( directory==null ){
            throw new Exception("retrieveFileObject: can not find directory "+dirName);
        }
        
        file = directory.getFileObject( fileName, javaFileExtension );
        if( file!=null ){
            file.delete( file.lock() );
            ref( "deleted ClassElement "+className );
        }
    }
    
    
    public DataObject writeClassElement(ClassElement clazz) throws Exception {
        DataObject jdo=null;
        String className="";
        try {
            className=clazz.getName().getFullName();
            int index=className.lastIndexOf('.');
            String dirName=index==-1?"":className.substring(0, index).replace('.', '/');
            String fileName=index==-1?className:className.substring(index+1);
            org.openide.filesystems.Repository repository=Repository.getDefault();
            FileObject directory=repository.findResource(dirName);
            FileObject file;
            
            if( directory==null ){
                ref( "writeClassElement: can not find directory "+dirName );
                return null;
            }
            
            org.openide.cookies.SourceCookie  srcCockie;
            org.openide.src.SourceElement srcElement;
            ClassElement  existingClass;
            
            file = directory.getFileObject( fileName, javaFileExtension );
            if( file!=null )
                file.delete( file.lock() );
            
            file = directory.createData( fileName, javaFileExtension );
            jdo = DataObject.find( file );
            srcCockie = (org.openide.cookies.SourceCookie) jdo.getCookie( org.openide.cookies.SourceCookie.class );
            srcElement = srcCockie.getSource();
            srcElement.setPackage( org.openide.src.Identifier.create(postPackageName));
            srcElement.addImport( new org.openide.src.Import(org.openide.src.Identifier.create("java.util.HashSet"), org.openide.src.Import.CLASS) );
            srcElement.addClass( clazz );
        } catch (Exception e) {
            ((SaveCookie)jdo.getCookie(SaveCookie.class)).save();
            ref( "class "+className+" written" );
            throw e;
        }
        ((SaveCookie)jdo.getCookie(SaveCookie.class)).save();
        ref( "class "+className+" written" );
        return jdo;
    }
    
}

