/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * Remover.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.parsing.Remover;

import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.netbeans.test.java.Common;

/** <B>Java Module General API Test: Remover</B>
 * <BR><BR><I>What it tests:</I><BR>
 * Removing and modifying existing Elements.
 * This tests takes complex class and tries to modify it's Elements (FieldElement, MethodElement, ClassElement, InitializerElement, ConstructorElement).
 * Modification is made using setters on this Elements.
 * Parser must have correct information about all Elements, otherwise removing is incorrect.
 * Test is focused on checking of correctness of generated code.
 * <BR><BR><I>How it works:</I><BR>
 * Existing class (javam.testsources.EtalonForRemover) is copy()ed using DataObject.copy() into different package (in order to preserve changes).
 * There are lots of modifications(using setters) made on this ClassElement's Elements. These are also romoved.
 * These actions cause generating of .java code. This code is compared with supposed one.
 * <BR><BR><I>Output:</I><BR>
 * Generated Java code.
 * <BR><BR><I>Possible reasons of failure:</I><BR>
 * <BR><BR><U>Exception occured:</U><BR>
 * This is the most probable case. See .out file for StackTrace it will be very usefull.
 * <BR><BR><U>Some Elements missing/are left over</U><BR>
 * See .diff file to get which ones
 * <BR><BR><U>Bad indentation</U><BR>
 * This is probably not a bug of Java Module. (Editor Bug)
 * In .diff file could be some whitespaces.
 *
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */


public class Remover extends org.netbeans.test.java.XRunner {
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public Remover() {
        super("");
    }
    
    public Remover(java.lang.String testName) {
        super(testName);
    }
    
    public static org.netbeans.junit.NbTest suite() {
        return new org.netbeans.junit.NbTestSuite(Remover.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        org.openide.src.ClassElement clazz = ((org.openide.src.SourceElement) o).getClasses()[0];
        
        FieldElement[] fieldsToRemove1 = new FieldElement[4];
        fieldsToRemove1[0] = clazz.getField(Identifier.create("a"));
        fieldsToRemove1[1] = clazz.getField(Identifier.create("f"));
        fieldsToRemove1[2] = clazz.getField(Identifier.create("fa"));
        fieldsToRemove1[3] = clazz.getField(Identifier.create("fe"));
        
        clazz.removeFields(fieldsToRemove1);
        
        clazz.getField(Identifier.create("b")).setType(org.openide.src.Type.FLOAT);
        clazz.getField(Identifier.create("d")).setType(org.openide.src.Type.FLOAT);
        
        
        FieldElement[] fieldsToRemove2 = new FieldElement[2];
        fieldsToRemove2[0] = clazz.getField(Identifier.create("c"));
        fieldsToRemove2[1] = clazz.getField(Identifier.create("e"));
        
        //!!!bug
        clazz.removeFields(fieldsToRemove2);
        
        clazz.removeMethod(clazz.getMethod(Identifier.create("doNothing"),null));
        clazz.removeMethod(clazz.getMethod(Identifier.create("doImportant"),null));
        
        org.openide.src.MethodElement[] methodsToRemove1 = new org.openide.src.MethodElement[3];
        methodsToRemove1[0] = clazz.getMethod(Identifier.create("method1"),Common.TPARS1);
        methodsToRemove1[1] = clazz.getMethod(Identifier.create("method2"),Common.TPARS1);
        methodsToRemove1[2] = clazz.getMethod(Identifier.create("method2"),Common.TPARS3);
        clazz.removeMethods(methodsToRemove1);
        
        clazz.removeClasses(clazz.getClasses());
        
        clazz.getField(Identifier.create("fb")).setInitValue("0.3");
        
        //???bug???
        clazz.getField(Identifier.create("fd")).setInitValue("0.4");
        
        org.openide.src.MethodElement me = clazz.getMethod(Identifier.create("method2"),Common.TPARS2);
        me.setName(Identifier.create("renamedMethod2"));
        me.setParameters(Common.PARS3);
        me.setReturn(org.openide.src.Type.FLOAT);
        me.setModifiers(java.lang.reflect.Modifier.SYNCHRONIZED | java.lang.reflect.Modifier.PRIVATE);
        return true;
    }
    
    /**
     */
    protected void setUp() {
        super.setUp();
        name = "Remover";
        packageName = "org.netbeans.test.java.testsources";
    }
    
}
