/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * ClassChanged.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.sourceexception.ClassChanged;

import org.openide.src.Identifier;
import org.openide.src.ClassElement;
import org.openide.src.SourceException;
import java.lang.reflect.Modifier;
import org.netbeans.test.java.Common;
import org.openide.loaders.DataObject;


/**
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */

public class ClassChanged extends org.netbeans.test.java.XRunner {
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public ClassChanged() {
        super("");
    }
    
    public ClassChanged(java.lang.String testName) {
        super(testName);
    }
    
    public static org.netbeans.junit.NbTest suite() {
        return new org.netbeans.junit.NbTestSuite(ClassChanged.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */    
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        
        ClassElement clazz = ((org.openide.src.SourceElement) o).getClasses()[0];
        System.setProperty(org.netbeans.test.java.eventfiring.MyListener.RESULT_KEY,"");
        boolean passed = true;
        
        ClassElement innerClass = new ClassElement();
        innerClass.setModifiers(Modifier.PUBLIC);
        innerClass.setSuperclass(Identifier.create("Obj"));
        innerClass.setName(Identifier.create("Inn","Inn"));
        clazz.addClass(innerClass);
        
        innerClass  = clazz.getClasses()[0];
        clazz.removeClass(innerClass);
        
        
        try {
            innerClass.setModifiers(Modifier.PUBLIC | Modifier.STATIC);
        } catch (SourceException e){
            ref("setModifiers succesfully throws "+e);
        }
        
        try {
            innerClass.setSuperclass(Identifier.create("Object"));
        } catch (SourceException e){
            ref("setSuperclass succesfully throws "+e);
        }
        
        try {
            innerClass.setName(Identifier.create("InnerClass","InnerClass"));
        } catch (SourceException e){
            ref("setName succesfully throws "+e);
        }
        
        try {
            innerClass.addMethod(Common.createMethod("method1", Modifier.PRIVATE | Modifier.SYNCHRONIZED, org.openide.src.Type.INT, Common.PARS2));
        } catch (SourceException e){
            ref("addMethod succesfully throws "+e);
        }
        
        try {
            innerClass.addField(Common.createField("field"));
        } catch (SourceException e){
            ref("addField succesfully throws "+e);
        }
        
        try {
            innerClass.addConstructor(Common.createConstructor(null,Common.PARS1));
        } catch (SourceException e){
            ref("addConstructor succesfully throws "+e);
        }
        
        try {
            innerClass.addClass(innerClass);
        } catch (SourceException e){
            ref("addClass succesfully throws "+e);
        }
        
        try {
            innerClass.addInitializer(Common.createInitializer());
        } catch (SourceException e){
            ref("addInitializer succesfully throws "+e);
        }
        
        try {
            innerClass.addInterface(Identifier.create("Iface"));
        } catch (SourceException e){
            ref("addInterface succesfully throws "+e);
        }
        
        return passed;
    }
    
    protected boolean writeResult(DataObject DO) {
        return true;
    }
    
    /**
     */    
    protected void setUp() {
        super.setUp();
        name = "JavaTestSourceExceptionThrowingClassChanged";
        packageName = "org.netbeans.test.java.testsources";
    }
    
}
