/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * FieldChanged.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.sourceexception.FieldChanged;

import org.openide.src.Type;
import org.openide.src.Identifier;
import org.openide.src.SourceException;
import java.lang.reflect.Modifier;
import org.openide.loaders.DataObject;


/**
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */

public class FieldChanged extends org.netbeans.test.java.XRunner {
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public FieldChanged() {
        super("");
    }
    
    public FieldChanged(java.lang.String testName) {
        super(testName);
    }
    
    public static org.netbeans.junit.NbTest suite() {
        return new org.netbeans.junit.NbTestSuite(FieldChanged.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */    
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        
        org.openide.src.ClassElement clazz = ((org.openide.src.SourceElement) o).getClasses()[0];
        System.setProperty(org.netbeans.test.java.eventfiring.MyListener.RESULT_KEY,"");
        boolean passed = true;
        
        org.openide.src.FieldElement fe = org.netbeans.test.java.Common.createField("newField",Modifier.PUBLIC | Modifier.STATIC , Type.BOOLEAN);
        clazz.addField(fe);
        fe = clazz.getField(Identifier.create("newField"));
        clazz.removeField(fe);
        
        try {
            fe.setType(Type.FLOAT);
        } catch (SourceException e){
            ref("setType succesfully throws "+e);
        }
        
        try {
            fe.setInitValue("3");
        } catch (SourceException e){
            ref("setInitValue succesfully throws "+e);
        }

        try {
            fe.setModifiers(Modifier.PROTECTED);
        } catch (SourceException e){
            ref("setModifiers succesfully throws "+e);
        }

        try {
            fe.setName(Identifier.create("ranamedField"));
        } catch (SourceException e){
            ref("setName succesfully throws "+e);
        }
        return passed;
    }
    
    protected boolean writeResult(DataObject DO) {
        return true;
    }
    
    /**
     */    
    protected void setUp() {
        super.setUp();
        name = "JavaTestSourceExceptionThrowingFieldChanged";
        packageName = "org.netbeans.test.java.testsources";
    }
}
