/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * MethodChanged.java
 *
 * Created on June 26, 2000, 9:29 AM
 */

package org.netbeans.test.java.sourceexception.MethodChanged;

import org.openide.src.Type;
import org.openide.src.Identifier;
import org.openide.src.SourceException;
import java.lang.reflect.Modifier;
import org.netbeans.test.java.Common;
import org.openide.loaders.DataObject;


/**
 * @author Jan Becicka <Jan.Becicka@sun.com>
 */

public class MethodChanged extends org.netbeans.test.java.XRunner {
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public MethodChanged() {
        super("");
    }
    
    public MethodChanged(java.lang.String testName) {
        super(testName);
    }
    
    public static org.netbeans.junit.NbTest suite() {
        return new org.netbeans.junit.NbTestSuite(MethodChanged.class);
    }
    
    /** "body" of this TestCase
     * @param o SourceElement - target for generating
     * @param log log is used for logging StackTraces
     * @throws Exception
     * @return true if test passed
     * false if failed
     */    
    public boolean go(Object o, java.io.PrintWriter log) throws Exception {
        
        org.openide.src.ClassElement clazz = ((org.openide.src.SourceElement) o).getClasses()[0];
        System.setProperty(org.netbeans.test.java.eventfiring.MyListener.RESULT_KEY,"");
        boolean passed = true;
        
        org.openide.src.MethodElement me = Common.createMethod("method1", Modifier.PUBLIC | Modifier.STATIC, Type.VOID, Common.PARS1);
        
        clazz.addMethod(me);
        me = clazz.getMethods()[0];
        clazz.removeMethod(me);
        
        try {
            me.setBody("//blah\n");
        } catch (SourceException e){
            ref("setBody succesfully throws "+e);
        }
        
        try {
            me.setExceptions(new Identifier[]{Identifier.create("java.lang.Exception","Exception")});
        } catch (SourceException e){
            ref("setExceptions succesfully throws "+e);
        }
        
        try {
            me.setModifiers(Modifier.PROTECTED);
        } catch (SourceException e){
            ref("setModifiers succesfully throws "+e);
        }
        
        try {
            me.setName(Identifier.create("ranamedMethod"));
        } catch (SourceException e){
            ref("setName succesfully throws "+e);
        }
        
        try {
            me.setParameters(Common.PARS2);
        } catch (SourceException e){
            ref("setParameters succesfully throws "+e);
        }
        
        try {
            me.setReturn(Type.CHAR);
        } catch (SourceException e){
            ref("setReturn succesfully throws "+e);
        }
        return passed;
    }
    
    protected boolean writeResult(DataObject DO) {
        return true;
    }
    
    /**
     */    
    protected void setUp() {
        super.setUp();
        name = "JavaTestSourceExceptionThrowingMethodChanged";
        packageName = "org.netbeans.test.java.testsources";
    }
}
