/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.changelog;

import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.*;

import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


import org.netbeans.modules.vcscore.actions.GeneralCommandAction;
import org.netbeans.modules.javacvs.commands.*;
import org.netbeans.modules.cvsclient.commands.*;
import org.netbeans.modules.cvsclient.NbJavaCvsFileSystem;
import org.netbeans.modules.cvsclient.actions.*;

import org.netbeans.modules.changelog.wizard.*;
import org.netbeans.modules.changelog.*;

/**
 * Runs a cvs log command, processes it's output and generates a changelog.
 * @author  Milos Kleint, Ralph Krueger
 */
public class ChangeLogAction extends CallBackCommandAction {


    private transient ChangeLogDisplayer displayer = null;
    private transient ChangeLogProcessor processor = null;
    
    private transient WizardDescriptor wd;
    
    /** Creates new UpdateCommandAction */
    public ChangeLogAction() {
    }

    public HelpCtx getHelpCtx() {
        HelpCtx retValue;
        
        retValue = super.getHelpCtx();
        return retValue;
    }
    
    protected String iconResource() {
       return null;
    }
    
    public String getName() {
        return NbBundle.getMessage(ChangeLogAction.class, "LBL_ChangeLogAction"); //NOI18N
    }
    
    
    /**
     * Runs a command and attaches the changelog displayer to it.
     * Should be called only from within the performsAction() code.
     * @param fs the filesystem that are the fileobjects related to.
     * @param fos part of files that are selected (they come from the same filesystem)
     */
    
    private void doChangeLog(NbJavaCvsFileSystem fs, FileObject[] fos) {
           CvsLog.LogImpl stImpl = (CvsLog.LogImpl)fs.createLog();
           stImpl.setNoTags(!processor.isIncludeBranchNames());
           stImpl.setUserFilter(processor.getUser());
           stImpl.setDateFilter(processor.getDateRange());
           stImpl.setRevisionFilter(processor.getRevisionRange());
           stImpl.setFileObjects(fos);
           if (displayer != null) {
               stImpl.addDisplayerListener(displayer);
           }
           stImpl.addDisplayerListener(new ErrorLogPanel(stImpl.getOuterClassInstance(), false));
           displayer.setNumberOfCommands(displayer.getNumberOfCommand() + 1);
           fs.prepareCommand(stImpl.getOuterClassInstance());
           stImpl.startCommand();
     }    
    
    /**
     * This method doesn't extract the fileobjects from the activated nodes itself, but rather
     * consults the AbstractCommandAction to get a list of supporters.
     * On this list then performs the action.
     */
    protected void performAction(final Node[] nodes) {
        String[] names = new String[3];
        names[0] = NbBundle.getBundle(ChangeLogAction.class).getString("ChangeLogAction.wizard_firstPanel");
        names[1] = NbBundle.getBundle(ChangeLogAction.class).getString("ChangeLogAction.wizard_secondPanel");
        names[2] = NbBundle.getBundle(ChangeLogAction.class).getString("ChangeLogAction.wizard_htmlPanel");
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[3];
        panels[0] = new FilterPanel.Panel(names[0]);
        panels[1] = new OutputPanel.Panel(names[1]);
        panels[2] = new HtmlPanel.Panel(names[2]);
        processor = new ChangeLogProcessor();
        wd = new WizardDescriptor(panels, processor);
        wd.setTitle(NbBundle.getBundle(ChangeLogAction.class).getString("ChangeLogAction.wizard_title"));
        wd.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        wd.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        wd.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        wd.putProperty("WizardPanel_contentData", names);
        
/*        wd.setButtonListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                if (wd != null) {
                    if (wd.getValue().equals(WizardDescriptor.FINISH_OPTION)) {
                        displayer = new ChangeLogDisplayer(processor);
                        ChangeLogAction.super.performAction(nodes);
                        wd = null;
                        processor = null;
                    }
                }
            }
        });
  */      
        final java.awt.Dialog dial = TopManager.getDefault().createDialog(wd);
        final WizardDescriptor desc = wd;
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                dial.show();
                if (desc.getValue().equals(WizardDescriptor.FINISH_OPTION)) {
                    displayer = new ChangeLogDisplayer(processor);
                    ChangeLogAction.super.performAction(nodes);
//                    wd = null;
                    processor = null;
                }
            }
        });
    }
    
    /**
     * Each supporter are checked if if they enable the action.
     * All supporters need to come to a concensus in order for the action to be enabled.
     * *experimental* annotates the toolbar tooltip according to the supporter's requests.
     */
    protected boolean enable(Node[] nodes) {
        boolean retValue;
        retValue = super.enable(nodes);
        return true;
    }    
    
    /** Is called from the ActionSupporter when it stops iterating the
     * collected filesystems and fileobjects..
     * Can be used for clean up, etc.
     *
     */
    public void finishCallBack() {
        super.finishCallBack();
    }
    
    /** Is called from the ActionSupporter when it starts iterating the
     * collected filesystems and fileobjects..
     * Can be used for initial settings, eg. to create a common displayer for everyone.
     *
     */
    public void initCallBack(JavaCvsActionSupporter supporter) {
        
    }
    
    /** method is called from the ActionSupporter and executes the action on the fileobjects..
     *
     */
    public void performCallBack(NbJavaCvsFileSystem fs, FileObject[] fos) {
        doChangeLog(fs, fos);
    }
    
}
