/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger. 
 */

package org.netbeans.modules.changelog;


import java.util.*;
import org.openide.*;
import java.io.*;


/**
 * A utility class.
 * @author  ralph
 */
public class ChangeLogUtils {
    
    /** method that converts the string value of the revision into an array of
     * integers for further processing
     */
    public static int[] convertRevisionToIntArray(String revision) {
       StringTokenizer token = new StringTokenizer(revision, ".");
       int[] array = new int[token.countTokens()];
       int index = 0;
       while (token.hasMoreTokens()) {
           String item = token.nextToken();
           try {
              int parsedNumber = Integer.parseInt(item);
              array[index] = parsedNumber;
           } catch (NumberFormatException exc) {
              array[index] = 0;      
           }
           index = index + 1;
       }
       return array;
    }

    /**
     * converts array of integers to a String conforming to the format of the cvs revisions
     * zero values are ignored. Can be used to shorten the resulting revision.
     */ 
    public static String convertIntArrayToRevision(int[] arr) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < arr.length; i++) {
            if (arr[i] == 0) {
                continue;
            }
            if (i != 0) {
                buffer.append('.');
            }
            buffer.append(arr[i]);
        }
        return buffer.toString();
    }
    

    /**
     * @param replMap - expects patterns as keys and replacement values as values
     *  aka ("filePath", "javacvs/build.xml")
     */
    public static String replaceArguments(String original, HashMap replMap) {
        Iterator it = replMap.keySet().iterator();
        while (it.hasNext()) {
            String pattern = (String)it.next();
            String value = (String)replMap.get(pattern);
            pattern = "{" + pattern + "}";
            int index = original.indexOf(pattern);
            if (index >= 0) {
                original = original.substring(0, index) + 
                          value + original.substring(index + pattern.length());
            }
        }
        return original;
    }
    
    private static final char[] charArray = new char[] {'>', '<', '&'};
    private static final String[] stringArray = 
        new String[] { "&gt;", "&lt;", "&amp;"};
    
    public static String escapeString(String original) {
        StringBuffer buffer = new StringBuffer(original);
        int index = 0;
        while (index < buffer.length()) {
            char character = buffer.charAt(index);
            for (int i = 0; i < charArray.length; i++) {
                if (character == charArray[i]) {
                    buffer.deleteCharAt(index);
                    buffer.insert(index, stringArray[i]);
                    index = index + stringArray[i].length();
                    continue;
                }
            }
            index = index + 1;
        }
        return buffer.toString();
    }
    
    private static final char[] xmlcharArray = new char[] {'>', '<', '&', '"', '\''};
    private static final String[] xmlstringArray = 
        new String[] { "&gt;", "&lt;", "&amp;", "&quot;", "&apos;" };
    
    public static String xmlescapeString(String original) {
        StringBuffer buffer = new StringBuffer(original);
        int index = 0;
        while (index < buffer.length()) {
            char character = buffer.charAt(index);
            for (int i = 0; i < xmlcharArray.length; i++) {
                if (character == xmlcharArray[i]) {
                    buffer.deleteCharAt(index);
                    buffer.insert(index, xmlstringArray[i]);
                    index = index + xmlstringArray[i].length();
                    continue;
                }
            }
            index = index + 1;
        }
        return buffer.toString();
    }

}
