/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger. 
 */

package org.netbeans.modules.changelog;


import java.util.*;
import org.openide.windows.*;
import org.openide.*;

/**
 * prints the processed groups to output window..
 * @author  ralph
 */
public class LogPrinter_Output implements LogPrinter {
    
    private OutputWriter writer;
    private boolean includeSummary;
    
    public LogPrinter_Output() {
         writer = TopManager.getDefault().getStdOut();
    }
    
    public void printHeader(ChangeLogProcessor processor) {
        includeSummary = processor.isIncludeSummary();
        if (processor.isIncludeQueryDescription()) {
            writer.println("Query:");
            if (processor.getDateRange() != null) {
                writer.println("   Date Range:" + processor.getDateRange());
            }
            if (processor.getRevisionRange() != null) {
                writer.println("   Revision Filter:" + processor.getRevisionRange());
            }
            if (processor.getMessageFilter() != null) {
                String messageType = "";
                if (processor.getMessageFilterType() == ChangeLogProcessor.MESSAGE_FILTER_SUBSTRING) {
                    messageType = "Substring";
                } else if (processor.getMessageFilterType() == ChangeLogProcessor.MESSAGE_FILTER_SOME_WORDS) {
                    messageType = "Any of words";
                } else if (processor.getMessageFilterType() == ChangeLogProcessor.MESSAGE_FILTER_ALL_WORDS) {
                    messageType = "All of words";
                } else if (processor.getMessageFilterType() == ChangeLogProcessor.MESSAGE_FILTER_REGEXP) {
                    messageType = "Regular expression";
                }
                writer.println("   Message Filter (" + messageType + "):" + processor.getMessageFilter());
            }
            if (processor.getFileFilter() != null) {
                String fileType = "";
                if (processor.getFileFilterType() == ChangeLogProcessor.FILE_FILTER_SUBSTRING) {
                    fileType = "Substring";
                } else if (processor.getFileFilterType() == ChangeLogProcessor.FILE_FILTER_REGEXP) {
                    fileType = "Regular expression";
                }
                writer.println("   Contained Files Filter (" + fileType + "):" + processor.getFileFilter());
            }
            if (processor.getSortMode() == ChangeLogProcessor.SORT_BY_DATE) {
                writer.print("   Sort: by Date");
            } else if (processor.getSortMode() == ChangeLogProcessor.SORT_BY_USER) {
                writer.print("   Sort: by User");
            }
            if (processor.isDescendingSort()) {
                writer.println(" (Descending)");
            } else {
                writer.println(" (Ascending)");
            }
        }
    }
    
    public void printGroupHeader(RevisionsGroup group) {
          writer.println("--------------------------------------------------");
          writer.println("User: " + group.getUser());
          writer.println("Date: " + group.getStartingDate());
          writer.println("Message:" + group.getMessage());
    }
    
    public void printSingleRevision(LogInfoRevision revision) {
        String repoFileName = revision.getLogInfoHeader().getRepositoryFilename();
        repoFileName = repoFileName.substring(0, repoFileName.length() - 2);
        writer.println("   " + revision.getNumber() + "  " + repoFileName);
    }
    
    public void printGroupFooter(RevisionsGroup group) {
        //do nothing
    }
    
    public void printSummary(SummaryProcessor processor) {
        if (includeSummary) {
            writer.println("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=");
            writer.println("Summary:");
            writer.println("Number of changes: " + processor.getCommitCount());
            writer.print("Developers: ");
            String[] users = processor.getUserList();
            for (int i = 0; i < users.length; i++) {
                if (i < users.length) {
                    writer.println(users[i] + ", ");
                } else {
                    writer.println(users[i]);
                }
            }
            writer.println();
            String[] mostChanged = processor.getMostChangedFiles();
            writer.println("Most frequently changed files:");
            for (int j = 0; j < mostChanged.length; j++) {
                writer.println(mostChanged[j]);
            }
            writer.println();
            writer.println("Most active developers (based on number of commits):");
            String[] mostActive= processor.getMostActiveUsers();
            for (int k = 0; k < mostActive.length; k++) {
                writer.println(mostActive[k]);
            }
            writer.println();
        }
    }
    
    public void printFooter(ChangeLogProcessor processor) {
        //do nothing
    }
    
}
