/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Ralph Krueger. 
 */

package org.netbeans.modules.changelog.settings;

import java.awt.Image;
import java.beans.*;

import org.openide.util.NbBundle;

/** BeanInfo for ChangeLogSettings
*
* @author Ralph Krueger
*/
public class ChangeLogSettingsBeanInfo extends SimpleBeanInfo {


    /** @return the  icon */
    public Image getIcon(int type) {
        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) || (type == java.beans.BeanInfo.ICON_MONO_16x16)) {
            return org.openide.util.Utilities.loadImage("org/netbeans/modules/changelog/resources/setting.gif"); //NOI18N;
        } else {
            return null;
        }

    }

    /** Descriptor of valid properties
    * @return array of properties
    */
    public PropertyDescriptor[] getPropertyDescriptors () {
        try {

            java.util.ResourceBundle bundle =
                NbBundle.getBundle(ChangeLogSettingsBeanInfo.class);

            
            PropertyDescriptor defaultServer = new PropertyDescriptor ("defaultServerInfo", ChangeLogSettings.class); // NOI18N
            defaultServer.setDisplayName (bundle.getString("PROP_defaultServerInfo")); // NOI18N
            defaultServer.setShortDescription (bundle.getString("HINT_defaultServerInfo"));      // NOI18N       
            defaultServer.setPropertyEditorClass(DefaultServerInfoPE.class);

            PropertyDescriptor showBranchesByDefault = new PropertyDescriptor ("showBranchesByDefault", ChangeLogSettings.class); // NOI18N
            showBranchesByDefault.setDisplayName (bundle.getString("PROP_showBranchesByDefault")); // NOI18N
            showBranchesByDefault.setShortDescription (bundle.getString("HINT_showBranchesByDefault"));      // NOI18N       
            
            return new PropertyDescriptor[] { defaultServer, showBranchesByDefault };
            
        } catch (IntrospectionException ie) {
            org.openide.ErrorManager.getDefault().notify();
            return null;
        }
    }
}

