/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.NotifyDescriptor;
import org.openide.DialogDisplayer;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.util.*;

/**
 * Opens the Commit dialog for all open projects.
 * 
 * @author Maros Sandor
 */
public class CommitProjectsAction extends SystemAction {

    public CommitProjectsAction() {
        setIcon(null);
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }

    public String getName() {
        return NbBundle.getMessage(CommitProjectsAction.class, "CTL_MenuItem_CommitProjects");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CommitProjectsAction.class);
    }

    public boolean isEnabled() {
        Project projects[] = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; i++) {
            Project project = projects[i];
            if (Utils.isVersionedProject(project)) {
                return true;
            }
        }
        return false;
    }
    
    public void actionPerformed(ActionEvent ev) {
        RequestProcessor.getDefault().post(new Runnable() {
            public void run() {
                async();
            }
        });
    }

    private void async() {

        Context ctx;
        ResourceBundle loc = NbBundle.getBundle(CommitProjectsAction.class);
        ProgressHandle progress = ProgressHandleFactory.createHandle(NbBundle.getMessage(CommitProjectsAction.class, "BK1009"));
        try {
            progress.start();
            Project [] projects = OpenProjects.getDefault().getOpenProjects();
            ctx = Utils.getProjectsContext(projects);

            if (ctx.getFiles().length == 0) {
                progress.finish();
                final NotifyDescriptor nd = new NotifyDescriptor.Message(loc.getString("MSG_NoProjectFiles_Prompt"));
                nd.setTitle(loc.getString("MSG_NoProjectFiles_Title"));
                DialogDisplayer.getDefault().notify(nd);
                return;
            }
        } finally {
            progress.finish();
        }

        CommitAction.invokeCommit(loc.getString("CTL_DialogTitle_AllProjects"), ctx, NbBundle.getMessage(CommitProjectsAction.class,"CTL_MenuItem_CommitProjectsRunning"));
    }
}
