/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

import javax.swing.*;
import java.io.File;
import java.awt.event.ActionEvent;
import java.util.*;

/**
 * Shows LOCAL diffs for all locally modified files in all open projects.
 * 
 * @author Maros Sandor
 */
public class DiffProjectsAction extends SystemAction {
    
    public DiffProjectsAction() {
        setIcon(null);
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }

    public String getName() {
        return NbBundle.getMessage(DiffProjectsAction.class, "CTL_MenuItem_DiffProjects");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DiffProjectsAction.class);
    }

    public boolean isEnabled() {
        Project projects[] = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; i++) {
            Project project = projects[i];
            if (Utils.isVersionedProject(project)) {
                return true;
            }
        }
        return false;
    }
    
    public void actionPerformed(ActionEvent ev) {
        RequestProcessor.getDefault().post(new Runnable() {
            public void run() {
                async();
            }
        });
    }

    private void async() {

        final ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage(DiffProjectsAction.class, "CTL_MenuItem_DiffProjectsRunning"));
        group.progress(NbBundle.getMessage(DiffProjectsAction.class, "BK2001"));
        Project [] projects = OpenProjects.getDefault().getOpenProjects();
        final Context ctx = Utils.getProjectsContext(projects);

        final ResourceBundle loc = NbBundle.getBundle(DiffProjectsAction.class);
        if (ctx.getFiles().length == 0) {
            group.executed();
            JOptionPane.showMessageDialog(null, loc.getString("MSG_NoProjectFiles_Prompt"),
                    loc.getString("MSG_NoProjectFiles_Title"), JOptionPane.INFORMATION_MESSAGE);
            return;
        }

        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                String title = loc.getString("CTL_DialogTitle_DiffProjects");
                DiffExecutor exec = new DiffExecutor(ctx, title);
                exec.showLocalDiff(group);
            }
        });
    }
}
