/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.openide.util.NbBundle;

import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

/**
 * Merge From Branch settings panel.
 *
 * @author  Maros Sandor
 */
class MergeBranchPanel extends javax.swing.JPanel implements DocumentListener {
    
    private final File[] roots;

    /** Creates new form MergeBranchPanel */
    public MergeBranchPanel(File [] roots) {
        this.roots = roots;
        initComponents();
        rbMergeFromTrunk.setSelected(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.mergeTrunk", true)); // NOI18N
        rbMergeFromBranch.setSelected(!CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.mergeTrunk", true)); // NOI18N
        cbUseMergeTag.setSelected(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.useMergeTag", false)); // NOI18N
        cbTagAfterMerge.setSelected(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.tagAfterMerge", false)); // NOI18N
        tfBranchName.setText(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.branchName", NbBundle.getMessage(MergeBranchPanel.class, "BK1001"))); // NOI18N
        tfBranchName.getDocument().addDocumentListener(this);
        tfMergeTagName.setText(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.mergeTagName", NbBundle.getMessage(MergeBranchPanel.class, "BK1002"))); // NOI18N
        tfAfterMergeTagName.setText(CvsModuleConfig.getDefault().getDefaultValue("MergeBranchSettings.afterMergeTagName", NbBundle.getMessage(MergeBranchPanel.class, "BK1003"))); // NOI18N
        tfCurrentBranch.setText(detectCurrentWorkingBranch());
        refreshComponents();        
    }

    /**
     * Takes the first file and returns its sticky tag.
     * 
     * @return branch of current files
     */ 
    private String detectCurrentWorkingBranch() {
        File root = roots[0];
        if (root.isFile()) {
            Entry entry = null;
            try {
                entry = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(root);
            } catch (IOException e) {
            }
            if (entry != null) {
                String sticky = entry.getStickyInformation();
                if (sticky != null) {
                    return sticky;
                }
            } else {
                root = root.getParentFile();
            }
        }
        if (root.isDirectory()) {
            String sticky = CvsVersioningSystem.getInstance().getAdminHandler().getStickyTagForDirectory(root);
            if (sticky != null  && sticky.startsWith("T")) {   // NOI18N
                return sticky.substring(1);
            }
        }
        return NbBundle.getBundle(MergeBranchPanel.class).getString("MSG_MergeBranchForm_Trunk");
    }

    public boolean isTaggingAfterMerge() {
        return cbTagAfterMerge.isSelected();
    }

    public boolean isUsingMergeTag() {
        return cbUseMergeTag.isSelected();
    }

    public boolean isMergingFromTrunk() {
        return rbMergeFromTrunk.isSelected();
    }

    public String getAfterMergeTagName() {
        return tfAfterMergeTagName.getText();
    }

    public String getBranchName() {
        return tfBranchName.getText();
    }

    public String getMergeTagName() {
        return tfMergeTagName.getText();
    }

    public void changedUpdate(DocumentEvent e) {
        refreshComponents();
    }

    public void insertUpdate(DocumentEvent e) {
        refreshComponents();
    }

    public void removeUpdate(DocumentEvent e) {
        refreshComponents();
    }

    private void refreshComponents() {
        tfBranchName.setEnabled(rbMergeFromBranch.isSelected());
        bBrowseBranch.setEnabled(rbMergeFromBranch.isSelected());
        tfMergeTagName.setEnabled(cbUseMergeTag.isSelected());
        bBrowseMergeTag.setEnabled(cbUseMergeTag.isSelected());
        tfAfterMergeTagName.setEnabled(cbTagAfterMerge.isSelected());
        bBrowseTagAfterMerge.setEnabled(cbTagAfterMerge.isSelected());
        String format = isMergingFromTrunk() ?
                java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagAfterMerge_Trunk") :
                java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagAfterMerge_Branch");
        cbTagAfterMerge.setText(MessageFormat.format(format, new Object [] { tfBranchName.getText() }));
    }

    public void saveSettings() {
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.mergeTrunk", rbMergeFromTrunk.isSelected()); // NOI18N
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.useMergeTag", cbUseMergeTag.isSelected()); // NOI18N
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.tagAfterMerge", cbTagAfterMerge.isSelected()); // NOI18N
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.branchName", tfBranchName.getText()); // NOI18N
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.mergeTagName", tfMergeTagName.getText()); // NOI18N
        CvsModuleConfig.getDefault().setDefaultValue("MergeBranchSettings.afterMergeTagName", tfAfterMergeTagName.getText()); // NOI18N
    }
    
    private String browseBranches() {
        for (int i = 0; i < roots.length; i++) {
            try {
                CVSRoot.parse(Utils.getCVSRootFor(roots[i]));  // raises exception
                BranchSelector selector = new BranchSelector();
                String tag = selector.selectTag(roots[i], null);
                return tag;
            } catch (IOException e) {
                // no root for this file, try next
            }
        }
        return null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        tfCurrentBranch = new javax.swing.JTextField();
        rbMergeFromTrunk = new javax.swing.JRadioButton();
        rbMergeFromBranch = new javax.swing.JRadioButton();
        tfBranchName = new javax.swing.JTextField();
        bBrowseBranch = new javax.swing.JButton();
        cbUseMergeTag = new javax.swing.JCheckBox();
        jLabel2 = new javax.swing.JLabel();
        tfMergeTagName = new javax.swing.JTextField();
        bBrowseMergeTag = new javax.swing.JButton();
        cbTagAfterMerge = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        tfAfterMergeTagName = new javax.swing.JTextField();
        bBrowseTagAfterMerge = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 0, 11));
        jLabel1.setLabelFor(tfCurrentBranch);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_CurrentBranch"));
        jLabel1.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_CurrentBranch"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
        add(jLabel1, gridBagConstraints);

        tfCurrentBranch.setColumns(10);
        tfCurrentBranch.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(tfCurrentBranch, gridBagConstraints);

        buttonGroup1.add(rbMergeFromTrunk);
        org.openide.awt.Mnemonics.setLocalizedText(rbMergeFromTrunk, java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_MergeFromTrunk"));
        rbMergeFromTrunk.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_MergeFromTrunk"));
        rbMergeFromTrunk.setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 0, 2, 0));
        rbMergeFromTrunk.setMargin(new java.awt.Insets(0, 0, 0, 0));
        rbMergeFromTrunk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonSwitch(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(rbMergeFromTrunk, gridBagConstraints);

        buttonGroup1.add(rbMergeFromBranch);
        org.openide.awt.Mnemonics.setLocalizedText(rbMergeFromBranch, java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_MergeFromBranch"));
        rbMergeFromBranch.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_MergeFromBranch"));
        rbMergeFromBranch.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        rbMergeFromBranch.setMargin(new java.awt.Insets(0, 0, 0, 0));
        rbMergeFromBranch.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonSwitch(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        add(rbMergeFromBranch, gridBagConstraints);

        tfBranchName.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
        add(tfBranchName, gridBagConstraints);
        tfBranchName.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("ACSN_MergeBranchForm_BranchTextField"));
        tfBranchName.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("ACSD_MergeBranchForm_BranchTextField"));

        org.openide.awt.Mnemonics.setLocalizedText(bBrowseBranch, java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_Browse"));
        bBrowseBranch.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_Browse"));
        bBrowseBranch.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseBranch(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        add(bBrowseBranch, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(cbUseMergeTag, java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_UseMergeTag"));
        cbUseMergeTag.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_UseMergeTag"));
        cbUseMergeTag.setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 0, 2, 0));
        cbUseMergeTag.setMargin(new java.awt.Insets(0, 0, 0, 0));
        cbUseMergeTag.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonSwitch(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(cbUseMergeTag, gridBagConstraints);

        jLabel2.setLabelFor(tfMergeTagName);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagName1"));
        jLabel2.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_TagName1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 6);
        add(jLabel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
        add(tfMergeTagName, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(bBrowseMergeTag, java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_UseMergeTag_Browse"));
        bBrowseMergeTag.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_UseMergeTag_Browse"));
        bBrowseMergeTag.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseMergeTag(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        add(bBrowseMergeTag, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(cbTagAfterMerge, java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagAfterMerge"));
        cbTagAfterMerge.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_TagAfterMerge"));
        cbTagAfterMerge.setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 0, 2, 0));
        cbTagAfterMerge.setMargin(new java.awt.Insets(0, 0, 0, 0));
        cbTagAfterMerge.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonSwitch(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(cbTagAfterMerge, gridBagConstraints);

        jLabel3.setLabelFor(tfAfterMergeTagName);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagName2"));
        jLabel3.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_TagName2"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        add(jLabel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
        add(tfAfterMergeTagName, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(bBrowseTagAfterMerge, java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_MergeBranchForm_TagAfterMerge_Browse"));
        bBrowseTagAfterMerge.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_MergeBranchForm_TagAfterMerge_Browse"));
        bBrowseTagAfterMerge.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseTagAfterMerge(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        add(bBrowseTagAfterMerge, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void browseTagAfterMerge(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseTagAfterMerge
        String tag = browseBranches();
        if (tag != null) {
            tfAfterMergeTagName.setText(tag);
        }
    }//GEN-LAST:event_browseTagAfterMerge

    private void browseMergeTag(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseMergeTag
        String tag = browseBranches();
        if (tag != null) {
            tfMergeTagName.setText(tag);
        }
    }//GEN-LAST:event_browseMergeTag

    private void browseBranch(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseBranch
        String tag = browseBranches();
        if (tag != null) {
            tfBranchName.setText(tag);
        }
    }//GEN-LAST:event_browseBranch

    private void buttonSwitch(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonSwitch
        refreshComponents();
    }//GEN-LAST:event_buttonSwitch
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bBrowseBranch;
    private javax.swing.JButton bBrowseMergeTag;
    private javax.swing.JButton bBrowseTagAfterMerge;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JCheckBox cbTagAfterMerge;
    private javax.swing.JCheckBox cbUseMergeTag;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JRadioButton rbMergeFromBranch;
    private javax.swing.JRadioButton rbMergeFromTrunk;
    private javax.swing.JTextField tfAfterMergeTagName;
    private javax.swing.JTextField tfBranchName;
    private javax.swing.JTextField tfCurrentBranch;
    private javax.swing.JTextField tfMergeTagName;
    // End of variables declaration//GEN-END:variables
    
}
