/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.admin;

/**
 * A class for comparing the file's date and the CVS/Entries date.
 *
 * @author  Thomas Singer
 * @version Sep 29, 2001
 */
public class DateComparator {

    private static final long SECONDS_PER_HOUR = 3600;

    private static final DateComparator singleton = new DateComparator();

    /**
     * Returns an instance of a DateComparator.
     */
    public static DateComparator getInstance() {
        return singleton;
    }

    /**
     * This class is a singleton. There is no need to subclass or
     * instantiate it outside.
     */
    private DateComparator() {
    }

    /**
     * Compares the specified dates, whether they should be treated as equal.
     * Returns true to indicate equality.
     */
    public boolean equals(final long fileTime, final long entryTime) {
        final long fileTimeSeconds = fileTime / 1000;
        final long entryTimeSeconds = entryTime / 1000;
        final long difference = Math.abs(fileTimeSeconds - entryTimeSeconds);
        // differences smaller than 1 second are treated as equal to catch rounding errors
        if (difference < 1) {
            return true;
        }

        // 1-hour-differences (caused by daylight-saving) are treated as equal
        if (difference >= SECONDS_PER_HOUR - 1
                && difference <= SECONDS_PER_HOUR + 1) {
            return true;
        }
        return false;
    }
}
