/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.*;

/**
 * Contains intercepted infomation from command standard output.
 * Actula data are held in temporary file.
 *
 */
public class PipedFileInformation extends FileInfoContainer {
    private File file;

    private String repositoryRevision;

    private String repositoryFileName;

    private File tempFile;

    private OutputStream tmpStream;
    
    public PipedFileInformation(File tempFile) {
        this.tempFile = tempFile;
        //this.tempFile.deleteOnExit();
        try {
            tmpStream = new BufferedOutputStream(new FileOutputStream(tempFile));
        }
        catch (IOException ex) {
            // TODO
        }
    }

    /**
     * Returns the original file. For piped content see {@link #getTempFile()}.
     */
    public File getFile() {
        return file;
    }

    /**
     * Sets the original file.
     */
    protected void setFile(File file) {
        this.file = file;
    }

    /**
     * Returns the revision of the incoming file.
     */
    public String getRepositoryRevision() {
        return repositoryRevision;
    }

    /**
     * Sets the revision of the incoming file.
     */
    protected void setRepositoryRevision(String repositoryRevision) {
        this.repositoryRevision = repositoryRevision;
    }

    /**
     * Returns the filename in the repository.
     */
    public String getRepositoryFileName() {
        return repositoryFileName;
    }

    /**
     * Sets the repository filename.
     */
    protected void setRepositoryFileName(String repositoryFileName) {
        this.repositoryFileName = repositoryFileName;
    }

    /**
     * Adds the specified line to the temporary file.
     */
    protected void addToTempFile(byte[] bytes) throws IOException {
        if (tmpStream != null) {
            tmpStream.write(bytes);
        }
    }
    /**
     * Adds the specified line to the temporary file.
     */
    public void addToTempFile(byte[] bytes, int len) throws IOException {
        if (tmpStream != null) {
            tmpStream.write(bytes, 0, len);
        }
    }

    protected void closeTempFile() throws IOException {
        if (tmpStream != null) {
            tmpStream.flush();
            tmpStream.close();
        }
    }

    public File getTempFile() {
        return tempFile;
    }

}
