/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient.command.checkout;

import java.util.*;

import org.netbeans.lib.cvsclient.command.*;
import org.netbeans.lib.cvsclient.event.*;

/**
 * Handles the building of module list information object and the firing of
 * events when complete objects are built.
 *
 * @author  Milos Kleint
 */
public class ModuleListBuilder implements Builder {
    /**
     * The module object that is currently being built.
     */
    private ModuleListInformation moduleInformation;

    /**
     * The event manager to use.
     */
    private final EventManager eventManager;

    private final CheckoutCommand checkoutCommand;

    public ModuleListBuilder(EventManager eventMan, CheckoutCommand comm) {
        eventManager = eventMan;
        checkoutCommand = comm;
    }

    public void outputDone() {
        if (moduleInformation != null) {
            eventManager.fireCVSEvent(new FileInfoEvent(this, moduleInformation));
            moduleInformation = null;
        }
    }

    public void parseLine(String line, boolean isErrorMessage) {
        line = line.replace('\t', ' ');
        if (!line.startsWith(" ")) { //NOI18N
            processModule(line, true);
        }
        else {
            processModule(line, false);
        }
    }

    protected void processModule(String line, boolean firstLine) {
        StringTokenizer tok = new StringTokenizer(line, " ", false); //NOI18N
        if (firstLine) {
            outputDone();
            moduleInformation = new ModuleListInformation();
            String modName = tok.nextToken();
            moduleInformation.setModuleName(modName);
            if (checkoutCommand.isShowModulesWithStatus()) {
                String stat = tok.nextToken();
                moduleInformation.setModuleStatus(stat);
            }
        }
        while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            if (nextTok.startsWith("-")) { //NOI18N
                moduleInformation.setType(nextTok);
                continue;
            }
            moduleInformation.addPath(nextTok);
        }
    }

    public void parseEnhancedMessage(String key, Object value) {
    }
}
