/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient.command.checkout;

import java.io.*;

import org.netbeans.lib.cvsclient.command.*;

/**
 * Object containing information about various modules defined in the repository.
 * Is parsed from the output of cvs checkout -c and cvs checkout -s.

 * @author   Milos Kleint
 */
public class ModuleListInformation extends FileInfoContainer {

    private String moduleName;

    private String moduleStatus;

    private final StringBuffer paths = new StringBuffer();

    private String type;

    public ModuleListInformation() {
    }

    public String getModuleName() {
        return moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleStatus() {
        return moduleStatus;
    }

    public void setModuleStatus(String moduleStatus) {
        this.moduleStatus = moduleStatus;
    }

    public String getPaths() {
        return paths.toString();
    }

    public void addPath(String path) {
        if (paths.length() > 0) {
            paths.append(' ');
        }
        paths.append(path);
    }

    public File getFile() {
        return null;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
