/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient.command.editors;

import java.io.*;
import java.util.*;

import org.netbeans.lib.cvsclient.command.*;

/**
 * Data object created by parsing the output of the Editors command.
 * @author  Thomas Singer
 */
public class EditorsFileInfoContainer extends FileInfoContainer {

    private final String client;
    private final Date date;
    private final File file;
    private final String user;

    EditorsFileInfoContainer(File file, String user, Date date, String client) {
        this.file = file;
        this.user = user;
        this.date = date;
        this.client = client;
    }

    public File getFile() {
        return file;
    }

    public String getClient() {
        return client;
    }

    public Date getDate() {
        return date;
    }

    public String getUser() {
        return user;
    }
}
