/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.command.remove;

import java.io.*;

import org.netbeans.lib.cvsclient.command.*;

/**
 * Describes remove information for a file. This is the result of doing a
 * cvs remove command. The fields in instances of this object are populated
 * by response handlers.
 *
 * @author  Milos Kleint
 */
public class RemoveInformation extends FileInfoContainer {
    private File file;
    private boolean removed;

    public RemoveInformation() {
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setRemoved(boolean rem) {
        removed = rem;
    }

    public boolean isRemoved() {
        return removed;
    }

    /**
     * Return a string representation of this object. Useful for debugging.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer(30);
        buf.append("  "); //NOI18N
        buf.append((file != null)
                           ? file.getAbsolutePath()
                           :"null"); //NOI18N
        return buf.toString();
    }
}
