/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.

 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.event;

/**
 * Indicates that a file has been removed.
 * @author  Robert Greig
 */
public class FileRemovedEvent extends CVSEvent {

    /**
     * The path of the file that has been removed.
     */
    protected String path;

    /**
     * Construct a FileRemovedEvent
     * @param source the source of the event
     * @param path The path of the file that has been removed
     */
    public FileRemovedEvent(Object source, String path) {
        super(source);
        this.path = path;
    }

    /**
     * Get the path of the file that has been removed.
     */
    public String getFilePath() {
        return path;
    }

    /**
     * Fire the event to the event listener. Subclasses should call the
     * appropriate method on the listener to dispatch this event.
     * @param listener the event listener
     */
    protected void fireEvent(CVSListener listener) {
        listener.fileRemoved(this);
    }
}
