/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Robert Greig.
 *
 * Contributor(s): Robert Greig, Milos Kleint.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.file;

import java.io.*;
import java.util.zip.*;

import org.netbeans.lib.cvsclient.request.*;

/**
 * Handles the reading and writing of Compressed files to and from the
 * server.
 * @author  Milos Kleint
 */
public class GzippedFileHandler extends DefaultFileHandler {
    /**
     * Indicates whether the file is actually compressed
     */
    private boolean isCompressed;

    /**
     * Get any requests that must be sent before commands are sent, to init
     * this file handler.
     * @return an array of Requests that must be sent
     */
    public Request[] getInitialisationRequests() {
        return new Request[]{
            new GzipStreamRequest()
        };
    }

    protected Reader getProcessedReader(File f) throws IOException {
        return new InputStreamReader(new GZIPInputStream(new
                FileInputStream(f)));
    }

    protected InputStream getProcessedInputStream(File f) throws IOException {
        return new GZIPInputStream(new FileInputStream(f));
    }
}