/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient.request;

/**
 * Sends the expand-modules request. This request expands the modules which
 * have been specified in previous argument requests. The server can assume
 * this is a checkout or export.<br>
 * Expand is not the best word for what this request does. It does not
 * expand a module in any meaningful way. What it does is ask the server
 * to tell you which working directories the server needs to know about in
 * order to handle a checkout of a specific module. This is important where
 * you have aliased modules. If you alias module foo as bar, then you need
 * to know when you do a checkout of foo that bar on disk is an existing
 * checkout of the module.
 * @author  Robert Greig
 * @see org.netbeans.lib.cvsclient.response.ModuleExpansionResponse
 */
public class ExpandModulesRequest extends Request {
    /**
     * Get the request String that will be passed to the server
     * @return the request String
     * @throws UnconfiguredRequestException if the request has not been
     * properly configured
     */
    public String getRequestString() throws UnconfiguredRequestException {
        return "expand-modules \n"; //NOI18N
    }

    /**
     * Is a response expected from the server?
     * @return true if a response is expected, false if no response if
     * expected
     */
    public boolean isResponseExpected() {
        return true;
    }
}

