/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.

 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.request;

import java.io.*;

import org.netbeans.lib.cvsclient.connection.*;
import org.netbeans.lib.cvsclient.file.*;

/**
 * The superclass of all requests made to the CVS server
 * @author  Robert Greig
 */
public abstract class Request {
    /**
     * Get the request String that will be passed to the server
     * @return the request String
     * @throws UnconfiguredRequestException if the request has not been
     * properly configured
     */
    public abstract String getRequestString()
            throws UnconfiguredRequestException;

    /**
     * Is a response expected from the server?
     * @return true if a response is expected, false if no response if
     * expected
     */
    public abstract boolean isResponseExpected();

    /**
     * If a file transmission is required, get the file object representing
     * the file to transmit after the request string. The default
     * implementation returns null, indicating no file is to be transmitted
     * @return the file object, if one should be transmitted, or null if
     * no file object is to be transmitted.
     */
    public FileDetails getFileForTransmission() {
        return null;
    }

    /**
     * Modify streams on the connection if necessary
     */
    public void modifyOutputStream(Connection connection) throws IOException {
        // DO NOTHING
    }

    /**
     * Modify streams on the connection if necessary
     */
    public void modifyInputStream(Connection connection) throws IOException {
        // DO NOTHING
    }

    /**
     * Does this request modify the input stream?
     * @return true if it does, false otherwise
     */
    public boolean modifiesInputStream() {
        return false;
    }
}