/*****************************************************************************
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * The Original Software is the CVS Client Library.
 * The Initial Developer of the Original Software is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.

 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.request;

import java.io.*;

/**
 * Tells the server that a particular filename has not been modified in the
 * checked-out directory.
 * @author  Robert Greig
 */
public class UnchangedRequest extends Request {
    /**
     * The filename of the file that is unchanged
     */
    private String filename;

    /**
     * Construct an Unchanged request
     * @param theFilename the unchanged file's name
     */
    public UnchangedRequest(String theFilename) {
        filename = theFilename;
    }

    /**
     * Construct an Unchanged request
     * @param file the unchanged file
     */
    public UnchangedRequest(File file) {
        filename = file.getName();
    }

    /**
     * Get the request String that will be passed to the server
     * @return the request String
     * @throws UnconfiguredRequestException if the request has not been
     * properly configured
     */
    public String getRequestString() throws UnconfiguredRequestException {
        if (filename == null)
            throw new UnconfiguredRequestException("Filename must be set");
        return "Unchanged " + filename + "\n"; //NOI18N
    }

    /**
     * Is a response expected from the server?
     * @return true if a response is expected, false if no response if
     * expected
     */
    public boolean isResponseExpected() {
        return false;
    }
}