/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient.response;

/**
 * Defines few hacks needed to support special and error cases.
 *
 * @author Petr Kuzel
 */
final class SpecialResponses {

    /**
     * Sometimes server aborts without sending <tt>error</tt> terminating
     * response. It sends just message reponse ending with following text.
     * <p>
     * It could terminate prematurely, ignoring <tt>error</tt> that should
     * be probably the next response. AFAIK it's harmless.
     * <p>
     * <a ref="http://tasklist.netbeans.org/issues/show_bug.cgi?id=56552">#56552</a>
     *
     */
    public static final String SERVER_ABORTED = " [server aborted]: received termination signal"; // NOI18N

    /**
     * Sometimes server aborts without sending <tt>error</tt> terminating
     * response. It sends just message reponse ending with following text.
     * <p>
     * It could terminate prematurely, ignoring <tt>error</tt> that should
     * be probably the next response. AFAIK it's harmless.
     * <p>
     * <a ref="http://tasklist.netbeans.org/issues/show_bug.cgi?id=56552">#56552</a>
     *
     */
    public static final String SERVER_ABORTED_2 = " [server aborted]: received broken pipe signal"; // NOI18N


    /**
     * Sometimes server aborts without sending <tt>error</tt> terminating
     * response. It sends just message reponse ending with following text.
     * <p>
     * It could terminate prematurely, ignoring <tt>error</tt> that should
     * be probably the next response. AFAIK it's harmless.
     * <p>
     * <a ref="http://tasklist.netbeans.org/issues/show_bug.cgi?id=63376">#63376</a>
     *
     */
    public static final String SERVER_ABORTED_3 = " [checkout aborted]: end of file from server (consult above messages if any)";  // NOI18N
}
