/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient;

import junit.framework.TestCase;

import java.io.*;
import java.util.Date;

import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;

/**
 * Commit command test suite.
 *
 * @author Petr Kuzel
 */
public class CommitTest extends TestCase {

    /**
     * Client must checks conflicted files timestamps. Until
     * it changes it should not commit the file (it actually
     * decides server by testing sent entry).
     * <p>
     * Uses fake PseudoCvsServer.
     */
    public void test36288() throws Exception {
        File tmpDir = TestKit.createTmpFolder("commitConflictTest");
        String protocolLog = new File(tmpDir, "protocol").getAbsolutePath();
        System.setProperty("cvsClientLog", protocolLog);
        System.out.println(protocolLog);

        // prepare working directory
        File CVSdir = new File(tmpDir, "CVS");
        CVSdir.mkdirs();
        File entries = new File(CVSdir, "Entries");
        OutputStream out = new FileOutputStream(entries);
        String dateString = "Thu Mar 24 15:14:27 2005";
        String data = "/conflict.txt/1.2/Result of merge+" + dateString + "//\nD";
        out.write(data.getBytes("utf8"));
        out.flush();
        out.close();

        File conflict_txt = new File(tmpDir, "conflict.txt");
        out = new FileOutputStream(conflict_txt);
        data = "AAA\n" +
                "BBB\n" +
                "<<<<<<< conflict.txt\n" +
                "YYY <= fix\n" +
                "=======\n" +
                "222 <= fix\n" +
                ">>>>>>> 1.2\n" +
                "DDD\n" +
                "EEE\n";
        out.write(data.getBytes("utf8"));
        out.flush();
        out.close();
        Date date = Entry.getLastModifiedDateFormatter().parse(dateString);
        conflict_txt.setLastModified(date.getTime());

        InputStream in = getClass().getResourceAsStream("protocol/iz36288.in");
        if (in == null) {
            System.err.println(getClass().getProtectionDomain().getCodeSource().getLocation().toExternalForm());
            in.markSupported();
        }
        PseudoCvsServer cvss = new PseudoCvsServer(in);

        File requestsLog = File.createTempFile("requests", null, tmpDir);
        cvss.logRequests(new FileOutputStream(requestsLog));
        new Thread(cvss).start();
        String cvsRoot = cvss.getCvsRoot();

        File root = new File(CVSdir, "Root");
        out = new FileOutputStream(root);
        out.write(cvsRoot.getBytes("utf8"));
        out.flush();
        out.close();

        File repo = new File(CVSdir, "Repository");
        out = new FileOutputStream(repo);
        out.write("/cvs".getBytes("utf8"));
        out.flush();
        out.close();

        // commit command
        CVSRoot CvsRoot = CVSRoot.parse(cvsRoot);
        GlobalOptions gtx = new GlobalOptions();
        gtx.setCVSRoot(cvsRoot);
        Connection connection = new PServerConnection(CvsRoot);
        Client client = new Client(connection, new StandardAdminHandler());
        client.setLocalPath(tmpDir.getAbsolutePath());

        CommitCommand commit = new CommitCommand();
        File[] files = new File[] {new File(tmpDir, "conflict.txt")};
        commit.setFiles(files);

        client.executeCommand(commit, gtx);
        cvss.stop();

        // check test matching golden file (here critical line from iz36288.out)

        InputStream actual = new FileInputStream(requestsLog);
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(actual, "utf8"));
        boolean foundConflictLine = false;
        String line = lineReader.readLine();
        StringBuffer sb = new StringBuffer();
        while (foundConflictLine == false && line != null) {
            sb.append(line + "\n");
            foundConflictLine |= "Entry /conflict.txt/1.2/+=//".equals(line);
            line = lineReader.readLine();
        }
        assertTrue("Missing 'Entry /conflict.txt/1.2/+=//' in:\n" + sb.toString(), foundConflictLine);

        TestKit.deleteRecursively(tmpDir);
    }

}
