/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.cvsclient;

import junit.framework.TestCase;

import java.io.*;

import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;

/**
 * Rlog command testcase.
 *
 * @author Petr Kuzel
 */
public class RlogTest extends TestCase {

    /**
     * Tests rlog wire format.
     */
    public void test57365() throws Exception {

        final File tmpDir = TestKit.createTmpFolder("rlogTest");
        String protocolLog = new File(tmpDir, "protocol").getAbsolutePath();
        System.setProperty("cvsClientLog", protocolLog);
        System.out.println(protocolLog);

        final InputStream in = getClass().getResourceAsStream("protocol/iz57365.in");
        if (in == null) {
            System.err.println(getClass().getProtectionDomain().getCodeSource().getLocation().toExternalForm());
            in.markSupported();
        }

        final File requestsLog = File.createTempFile("requests", null, tmpDir);

        final Exception testException[] = new Exception[1];
        final boolean completedFlag[] = new boolean[] {false};
        Runnable run = new Runnable() {
            public void run() {
                try {
                    PseudoCvsServer cvss = new PseudoCvsServer(in);
                    cvss.logRequests(new FileOutputStream(requestsLog));
                    try {
                        new Thread(cvss).start();

                        String cvsRoot = cvss.getCvsRoot();
                        CVSRoot root = CVSRoot.parse(cvsRoot);
                        GlobalOptions gtx = new GlobalOptions();
                        gtx.setCVSRoot(cvsRoot);
                        Connection connection = new PServerConnection(root);
                        Client client = new Client(connection, new StandardAdminHandler());
                        client.setLocalPath(tmpDir.getAbsolutePath());

                        RlogCommand rlog = new RlogCommand();
                        rlog.setModule("folder/file");

                        client.executeCommand(rlog, gtx);
                        synchronized(completedFlag) {
                            completedFlag[0] = true;
                            completedFlag.notifyAll();
                        }

                    } finally {
                        cvss.stop();;
                    }
                } catch (Exception ex) {
                    testException[0] = ex;
                }
            }
        };

        Thread t = new Thread(run);
        t.start();
        synchronized(completedFlag) {
            if (completedFlag[0] == false) {
                completedFlag.wait(1000); // 'INFINITE' TIMEOUT
            }
        }
        t.interrupt();
        if (testException[0] != null) {
            throw testException[0];
        }

        // check send data

        InputStream actual = new FileInputStream(requestsLog);
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(actual, "utf8"));
        boolean foundDirectoryLine = false;
        boolean foundRlog = false;
        String line = lineReader.readLine();
        StringBuffer sb = new StringBuffer();
        while (line != null) {
            sb.append(line + "\n");
            foundDirectoryLine |= line.startsWith("Directory");
            foundRlog |= line.equals("rlog");
            line = lineReader.readLine();
        }
        assertFalse("Local state is irrelevant in:\n" + sb.toString(), foundDirectoryLine);
        assertTrue("Where is rlog? in:" + sb.toString(), foundRlog);
        TestKit.deleteRecursively(tmpDir);

    }
    
}
