/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CookieAction;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataFolder;
import org.openide.filesystems.FileObject;
import org.netbeans.jmi.javamodel.Element;

import java.util.List;
import java.util.LinkedList;
import java.util.Iterator;

/**
 * Searches given folder for java sources and provides their Javadoc
 * correction dialogs.
 *
 * @author   Petr Hrebejk
 */
public class AutoCommentAction extends CookieAction {
    
    static final long serialVersionUID =4989490116568783623L;

    public AutoCommentAction() {
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    /** Human presentable name of the action. This should be
     * presented as an item in a menu.
     * @return the name of the action
     */
    public String getName() {
        return NbBundle.getBundle( AutoCommentAction.class ).getString("CTL_AUTOCOMMENT_MenuItem");    //NOI18N
    }
    
    /** Cookie classes contains one class returned by cookie () method.
     */
    protected final Class[] cookieClasses() {
        return new Class[] { DataFolder.class, SourceCookie.Editor.class };
    }
    
    /** All must be DataFolders or JavaDataObjects
     */
    protected int mode() {
        return MODE_ALL;
    }
    
    /** Help context where to find more about the action.
     * @return the help context for this action
     */
    public HelpCtx getHelpCtx() {
        return new HelpCtx(AutoCommentAction.class);
    }
    
    
    protected boolean enable( Node[] activatedNodes ) {
        if( activatedNodes.length == 0 )
            return false;
        List/*<Node>*/ unresolvedNodes = new LinkedList();
        for( int i = 0; i < activatedNodes.length; i++ ){
            Lookup lkp = activatedNodes[i].getLookup();
            if (lkp.lookup(Element.class) == null // hierarchy node?
                    && lkp.lookup(SourceCookie.class) == null) { // java node?
                
                unresolvedNodes.add(activatedNodes[i]);
                continue;
            }
            
            DataObject doj = (DataObject) lkp.lookup(DataObject.class);
            if( doj == null || !(doj.getPrimaryFile().canWrite()) )
                return false;
        }
        if(unresolvedNodes.isEmpty())
            return true;
        else {
            return findInFolder( unresolvedNodes );
        }
    }
    
    /**
     * @param unresolvedNodes activated nodes on which look up
     * @return false if there is any uncommentable source
     */
    private boolean findInFolder(List/*<Node>*/ unresolvedNodes){
        // check if all nodes are folders
        for (Iterator it = unresolvedNodes.iterator(); it.hasNext();) {
            Node node = (Node) it.next();
            DataFolder df = (DataFolder) node.getLookup().lookup(DataFolder.class);
            if (df == null || !isPackage(df.getPrimaryFile())) {
                return false;
            }
        }
        

        // all folders should be packages
        return true;
    }

    /**
     * Optimized detection of packages. Using Classpath API is too expensive
     * (see issue #67027).
     * @param fo file to check
     * @return if it is a package
     */
    private static boolean isPackage(FileObject fo) {
        if (!fo.canWrite()) {
            return false;
        }

        FileObject[] children = fo.getChildren();

        for (int i = 0; i < children.length; i++) {
            FileObject child = children[i];
            if ("java".equalsIgnoreCase(child.getExt()) // NOI18N
                    && child.isData() && child.canWrite()) {
                return true;
            }
        }

        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    /** This method is called by one of the "invokers" as a result of
     * some user's action that should lead to actual "performing" of the action.
     * This default implementation calls the assigned actionPerformer if it
     * is not null otherwise the action is ignored.
     */
    public void performAction( Node[] nodes ) {
        
        AutoCommentTopComponent acTopComponent = AutoCommentTopComponent.getDefault();
        
        acTopComponent.open();
        acTopComponent.requestActive();
        
        acTopComponent.setAutoCommenter( new AutoCommenter( nodes ));
    }
}
