/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import java.awt.*;
import javax.swing.*;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/** Just sets the right icon to IndexItem

 @author Petr Hrebejk
*/
class AutoCommentListCellRenderer extends DefaultListCellRenderer {


    private static ImageIcon theIcon = new ImageIcon();

    static final long serialVersionUID =-5753071739523904697L;
    
    public Component getListCellRendererComponent( JList list,
            Object value,
            int index,
            boolean isSelected,
            boolean cellHasFocus) {

        JLabel cr = (JLabel)super.getListCellRendererComponent( list, value, index, isSelected, cellHasFocus );
        if ( value == AutoCommentPanel.WAIT_STRING ) {
            cr.setText(JavaMetamodel.getManager().isScanInProgress()? NbBundle.getMessage(AutoCommentListCellRenderer.class, "CTL_WaitScan"): NbBundle.getMessage( AutoCommentListCellRenderer.class, "CTL_Wait" ) ); //NOI18N
            theIcon.setImage( Utilities.loadImage("org/openide/src/resources/wait.gif") ); //NOI18N
            cr.setIcon( theIcon );
        } else {
            ElementDescriptor desc = ((AutoCommenter.Element) value).getDescriptor();
            cr.setText(desc.getFormattedName());
            cr.setIcon(desc.getIcon());
        }
        return cr;
    }

}
