/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import java.lang.reflect.Modifier;
import java.util.ResourceBundle;
import javax.swing.*;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import java.awt.*;

import org.openide.ErrorManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

import org.netbeans.modules.javadoc.settings.DocumentationSettings;
import org.netbeans.api.javahelp.Help;
import org.openide.src.JavaDoc;
import org.openide.util.*;

/**
 */
public class AutoCommentPanel
extends javax.swing.JPanel
implements ListSelectionListener, AutoCommenter.AutoCommentChangeListener {
    
    AutoCommenter autoCommenter;
    
    private JavaDocEditorPanel javaDocEditor = new JavaDocEditorPanel();
    private boolean resetingAll = false;
    private boolean updatingBadList = false;
    
    private final DefaultListModel EMPTY_MODEL = new DefaultListModel();
    static final String WAIT_STRING = "WAIT.MODEL"; // NOI18N
    private final DefaultListModel WAIT_MODEL = new DefaultListModel();
    
    private int modifierMask;
    private int errorMask;
    /** The state of the window is stored in hidden options of DocumentationSettings */
    DocumentationSettings dss = ((DocumentationSettings)SharedClassObject.findObject(DocumentationSettings.class, true));
    
    static final long serialVersionUID =1845033305150331568L;
    /** last selected items of the {@link #badList} */
    private Object[] LAST_SELECTION;

    /** Creates new form AutoCommentPanel
     */
    public AutoCommentPanel() {
        WAIT_MODEL.addElement( WAIT_STRING );
        initComponents ();
        
        // unselectable error list
        this.errorListBox.setCellRenderer(new DefaultListCellRenderer() {
            public Component getListCellRendererComponent(
                    JList list,
                    Object value,
                    int index,
                    boolean isSelected,
                    boolean cellHasFocus) {
                return super.getListCellRendererComponent(list, value, index, false, false);
            }
            
        });
        
        javaDocEditor.setEnabled(false);
        
        ResourceBundle b = org.openide.util.NbBundle.getBundle(AutoCommentPanel.class);
        defaultButton.setMnemonic( b.getString("CTL_AutoCommentPanel.defaultButton.text_Mnemonic").charAt(0) );
        sourceButton.setMnemonic( b.getString("CTL_AutoCommentPanel.sourceButton.text_Mnemonic").charAt(0) );
        refreshButton.setMnemonic( b.getString("CTL_AutoCommentPanel.refreshButton.text_Mnemonic").charAt(0) );
        helpButton.setMnemonic( b.getString("CTL_AutoCommentPanel.helpButton.text_Mnemonic").charAt(0) );
        
        okButton.setMnemonic(b.getString("MNEMO_AutoCommentPanel.okButton").charAt(0));
        errButton.setMnemonic(b.getString("MNEMO_AutoCommentPanel.errButton").charAt(0));
        missButton.setMnemonic(b.getString("MNEMO_AutoCommentPanel.missButton").charAt(0));
        publicButton.setMnemonic(b.getString("MNEMO_AutoCommentPanel.publicButton").charAt(0));
        packageButton.setMnemonic(b.getString("MNEMO_AutoCommentPanel.packageButton").charAt(0));
        protectedButton.setMnemonic(b.getString("MNEMO_AutoCommentPanel.protectedButton").charAt(0));
        privateButton.setMnemonic(b.getString("MNEMO_AutoCommentPanel.privateButton").charAt(0));
        
        splittedPanel = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, classInfoPanel, javaDocEditor);
        splittedPanel.setDividerSize(5);
        add(splittedPanel);
        
        okButton.setIcon(new ImageIcon(Utilities.loadImage("org/netbeans/modules/javadoc/comments/resources/ok.gif"))); // NOI18N
        errButton.setIcon(new ImageIcon(Utilities.loadImage("org/netbeans/modules/javadoc/comments/resources/error.gif"))); // NOI18N
        missButton.setIcon(new ImageIcon(Utilities.loadImage("org/netbeans/modules/javadoc/comments/resources/missing.gif"))); // NOI18N
        
        publicButton.setIcon(new ImageIcon(Utilities.loadImage("org/netbeans/modules/javadoc/comments/resources/public.gif"))); // NOI18N
        packageButton.setIcon(new ImageIcon(Utilities.loadImage("org/netbeans/modules/javadoc/comments/resources/package.gif"))); // NOI18N
        protectedButton.setIcon(new ImageIcon(Utilities.loadImage("org/netbeans/modules/javadoc/comments/resources/protected.gif"))); // NOI18N
        privateButton.setIcon(new ImageIcon(Utilities.loadImage("org/netbeans/modules/javadoc/comments/resources/private.gif"))); // NOI18N
        
        resolveButtonState();
        
        badList.setCellRenderer( new AutoCommentListCellRenderer() );
        badList.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        
        elementSelection( new ListSelectionEvent( badList.getModel(), -1, -1, false ) );
        initAccessibility(b);
    }
    
    private void initAccessibility(ResourceBundle b)
    {
        badList.getAccessibleContext().setAccessibleName(b.getString("ACS_AutoCommentPanel.methodListA11yName"));  // NOI18N
        badList.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AutoCommentPanel.methodListA11yDesc"));  // NOI18N
        nameLabel.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AutoCommentPanel.nameLabel.textA11yDesc"));  // NOI18N
        classTextField.getAccessibleContext().setAccessibleName(b.getString("ACS_AutoCommentPanel.nameTextField.textA11yName"));  // NOI18N
        errorListBox.getAccessibleContext().setAccessibleName(b.getString("ACS_AutoCommentPanel.commentList.textA11yName"));  // NOI18N
        errorListBox.getAccessibleContext().setAccessibleDescription(b.getString("ACS_AutoCommentPanel.commentList.textA11yDesc"));  // NOI18N
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        classInfoPanel = new javax.swing.JPanel();
        filterPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JToggleButton();
        errButton = new javax.swing.JToggleButton();
        missButton = new javax.swing.JToggleButton();
        publicButton = new javax.swing.JToggleButton();
        packageButton = new javax.swing.JToggleButton();
        protectedButton = new javax.swing.JToggleButton();
        privateButton = new javax.swing.JToggleButton();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        badList = new javax.swing.JList();
        buttonPanel = new javax.swing.JPanel();
        defaultButton = new javax.swing.JButton();
        sourceButton = new javax.swing.JButton();
        refreshButton = new javax.swing.JButton();
        helpButton = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        detailsPanel = new javax.swing.JPanel();
        nameLabel = new javax.swing.JLabel();
        classTextField = new javax.swing.JTextField();
        jScrollPane2 = new javax.swing.JScrollPane();
        errorListBox = new javax.swing.JList();

        FormListener formListener = new FormListener();

        setLayout(new java.awt.BorderLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 0, 0, 0)));
        classInfoPanel.setLayout(new java.awt.GridBagLayout());

        classInfoPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(6, 6, 5, 5)));
        classInfoPanel.setName("classInfoPanel");
        filterPanel.setLayout(new java.awt.GridBagLayout());

        okButton.setSelected(true);
        okButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutoCommentPanel.okButton.toolTipText"));
        okButton.setActionCommand("ALL");
        okButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        okButton.addActionListener(formListener);

        filterPanel.add(okButton, new java.awt.GridBagConstraints());

        errButton.setSelected(true);
        errButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutoCommentPanel.errButton.toolTipText"));
        errButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        errButton.addActionListener(formListener);

        filterPanel.add(errButton, new java.awt.GridBagConstraints());

        missButton.setSelected(true);
        missButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutoCommentPanel.missButton.toolTipText"));
        missButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        missButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 6);
        filterPanel.add(missButton, gridBagConstraints);

        publicButton.setSelected(true);
        publicButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutoCommentPanel.publicButton.toolTipText"));
        publicButton.setActionCommand("PUBLIC");
        publicButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        publicButton.addActionListener(formListener);

        filterPanel.add(publicButton, new java.awt.GridBagConstraints());

        packageButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutoCommentPanel.packageButton.toolTipText"));
        packageButton.setActionCommand("PACKAGE");
        packageButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        packageButton.addActionListener(formListener);

        filterPanel.add(packageButton, new java.awt.GridBagConstraints());

        protectedButton.setSelected(true);
        protectedButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutoCommentPanel.protectedButton.toolTipText"));
        protectedButton.setActionCommand("PROTECTED");
        protectedButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        protectedButton.addActionListener(formListener);

        filterPanel.add(protectedButton, new java.awt.GridBagConstraints());

        privateButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutoCommentPanel.privateButton.toolTipText"));
        privateButton.setActionCommand("PRIVATE");
        privateButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        privateButton.addActionListener(formListener);

        filterPanel.add(privateButton, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        filterPanel.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 6);
        classInfoPanel.add(filterPanel, gridBagConstraints);

        badList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        badList.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("ACS_AutoCommentPanel.methodListA11yDesc"));
        jScrollPane1.setViewportView(badList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        classInfoPanel.add(jScrollPane1, gridBagConstraints);

        buttonPanel.setLayout(new java.awt.GridBagLayout());

        buttonPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(0, 5, 0, 0)));
        defaultButton.setText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutoCommentPanel.defaultButton.text"));
        defaultButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("ACS_AutoCommentPanel.defaultButton.textA11yDesc"));
        defaultButton.setActionCommand("Default Comment");
        defaultButton.setMargin(new java.awt.Insets(2, 4, 2, 4));
        defaultButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        buttonPanel.add(defaultButton, gridBagConstraints);

        sourceButton.setText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutoCommentPanel.sourceButton.text"));
        sourceButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("ACS_AutoCommentPanel.sourceButton.textA11yDesc"));
        sourceButton.setMargin(new java.awt.Insets(2, 4, 2, 4));
        sourceButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        buttonPanel.add(sourceButton, gridBagConstraints);

        refreshButton.setText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutoCommentPanel.refreshButton.text"));
        refreshButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("ACS_AutoCommentPanel.refreshButton.textA11yDesc"));
        refreshButton.setMargin(new java.awt.Insets(2, 4, 2, 4));
        refreshButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        buttonPanel.add(refreshButton, gridBagConstraints);

        helpButton.setText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutocommentPanel.helpButton.text"));
        helpButton.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("CTL_AutocommentPanel.helpButton.tooltipText"));
        helpButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(11, 0, 0, 0);
        buttonPanel.add(helpButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        buttonPanel.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 6);
        classInfoPanel.add(buttonPanel, gridBagConstraints);

        detailsPanel.setLayout(new java.awt.GridBagLayout());

        nameLabel.setLabelFor(classTextField);
        nameLabel.setText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("AutoCommentPanel.nameLabel.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 11, 0);
        detailsPanel.add(nameLabel, gridBagConstraints);

        classTextField.setEditable(false);
        classTextField.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("ACS_AutoCommentPanel.nameTextField.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 11, 0);
        detailsPanel.add(classTextField, gridBagConstraints);

        errorListBox.setToolTipText(org.openide.util.NbBundle.getBundle(AutoCommentPanel.class).getString("ACS_AutoCommentPanel.commentList.textA11yDesc"));
        jScrollPane2.setViewportView(errorListBox);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        detailsPanel.add(jScrollPane2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.4;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 6);
        classInfoPanel.add(detailsPanel, gridBagConstraints);

        add(classInfoPanel, java.awt.BorderLayout.CENTER);

    }

    // Code for dispatching events from components to event handlers.

    private class FormListener implements java.awt.event.ActionListener {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            if (evt.getSource() == okButton) {
                AutoCommentPanel.this.okButtonActionPerformed(evt);
            }
            else if (evt.getSource() == errButton) {
                AutoCommentPanel.this.errButtonActionPerformed(evt);
            }
            else if (evt.getSource() == missButton) {
                AutoCommentPanel.this.missButtonActionPerformed(evt);
            }
            else if (evt.getSource() == publicButton) {
                AutoCommentPanel.this.publicButtonActionPerformed(evt);
            }
            else if (evt.getSource() == packageButton) {
                AutoCommentPanel.this.packageButtonActionPerformed(evt);
            }
            else if (evt.getSource() == protectedButton) {
                AutoCommentPanel.this.protectedButtonActionPerformed(evt);
            }
            else if (evt.getSource() == privateButton) {
                AutoCommentPanel.this.privateButtonActionPerformed(evt);
            }
            else if (evt.getSource() == defaultButton) {
                AutoCommentPanel.this.defaultButtonActionPerformed(evt);
            }
            else if (evt.getSource() == sourceButton) {
                AutoCommentPanel.this.sourceButtonActionPerformed(evt);
            }
            else if (evt.getSource() == refreshButton) {
                AutoCommentPanel.this.refreshButtonActionPerformed(evt);
            }
            else if (evt.getSource() == helpButton) {
                AutoCommentPanel.this.helpButtonActionPerformed(evt);
            }
        }
    }
    // </editor-fold>//GEN-END:initComponents

    private void helpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpButtonActionPerformed
        Help help=(Help)Lookup.getDefault().lookup(Help.class);
        
        help.showHelp(
            new org.openide.util.HelpCtx(AutoCommentTopComponent.AUTO_COMMENT_HELP_CTX_KEY));
    }//GEN-LAST:event_helpButtonActionPerformed
        
    private void missButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_missButtonActionPerformed
        refreshState();
    }//GEN-LAST:event_missButtonActionPerformed
    
    private void errButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_errButtonActionPerformed
        refreshState();
    }//GEN-LAST:event_errButtonActionPerformed
    
    private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        refreshState();
    }//GEN-LAST:event_okButtonActionPerformed
    
    private void refreshButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_refreshButtonActionPerformed
        resetingAll = true;
        updateForClosing();
        resetState();
    }//GEN-LAST:event_refreshButtonActionPerformed
    
    
    private void privateButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_privateButtonActionPerformed
        refreshState();
    }//GEN-LAST:event_privateButtonActionPerformed
    
    private void protectedButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_protectedButtonActionPerformed
        refreshState();
    }//GEN-LAST:event_protectedButtonActionPerformed
    
    private void packageButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_packageButtonActionPerformed
        refreshState();
    }//GEN-LAST:event_packageButtonActionPerformed
    
    private void publicButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_publicButtonActionPerformed
        refreshState();
    }//GEN-LAST:event_publicButtonActionPerformed
    
        
    private void defaultButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultButtonActionPerformed
        int sel = badList.getMinSelectionIndex();
        
        if ( sel == -1 )
            return;
        
        AutoCommenter.Element[] elements = getSelectedElements();
        if (elements.length == 1) {
            JavaDoc doc = null;
            javaDocEditor.commitTagChange();
            if (javaDocEditor.isDirty()) {
                doc = javaDocEditor.getUpdatedJavaDoc();
            }
            this.autoCommenter.autoCorrectJavadoc(elements[0], doc);
        } else {
            this.autoCommenter.autoCorrectJavadoc(elements);
        }
    }//GEN-LAST:event_defaultButtonActionPerformed
    
    private void sourceButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sourceButtonActionPerformed
        int sel = badList.getMinSelectionIndex();
        
        if ( sel == -1 || !badList.isEnabled())
            return;

        final AutoCommenter.Element element = (AutoCommenter.Element) badList.getModel().getElementAt( sel );
        if (element.isValid()) {
            element.viewSource();
        }

    }//GEN-LAST:event_sourceButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList badList;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JPanel classInfoPanel;
    private javax.swing.JTextField classTextField;
    private javax.swing.JButton defaultButton;
    private javax.swing.JPanel detailsPanel;
    private javax.swing.JToggleButton errButton;
    private javax.swing.JList errorListBox;
    private javax.swing.JPanel filterPanel;
    private javax.swing.JButton helpButton;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JToggleButton missButton;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JToggleButton okButton;
    private javax.swing.JToggleButton packageButton;
    private javax.swing.JToggleButton privateButton;
    private javax.swing.JToggleButton protectedButton;
    private javax.swing.JToggleButton publicButton;
    private javax.swing.JButton refreshButton;
    private javax.swing.JButton sourceButton;
    // End of variables declaration//GEN-END:variables
    private JSplitPane splittedPanel;
       
    public void updateForClosing() {
        int sel = badList.getMinSelectionIndex();
        boolean isNotMultiselect = sel == badList.getMaxSelectionIndex();
        if (sel >= 0 && isNotMultiselect) {
            if( !(badList.getModel().getElementAt( 0 ) instanceof AutoCommenter.Element) )
                  return;
            javaDocEditor.updateForClosing();
            AutoCommenter.Element el = (AutoCommenter.Element) badList.getModel().getElementAt(sel);
            if (el.isValid() && badList.isEnabled()) {
                modifyJavaDoc(el);
            }
        }
    }
    
    private void showCommentEditor( final AutoCommenter.Element el ) {
        javaDocEditor.setElement(el);
        javaDocEditor.setJavaDoc(el.getJavaDoc());
    }
    
    private void modifyJavaDoc(final AutoCommenter.Element el) {
        javaDocEditor.commitTagChange();
        if (! javaDocEditor.isDirty()) {
            return;
        }
        this.autoCommenter.modifyJavadoc(el, javaDocEditor.getUpdatedJavaDoc());
        javaDocEditor.setDirty(false);
    }
    
    private void elementSelection( ListSelectionEvent evt ) {
        // This is to prevente an infinite loop when performing an update to
        // the list
        if (updatingBadList || (evt != null && evt.getValueIsAdjusting())) {
            return;
        }
        
        int sel = badList.getMinSelectionIndex();
        boolean isMultiselect = sel != badList.getMaxSelectionIndex();
        ListModel badModel = badList.getModel();
        
        // If there was an item selected before changing, check to see if we
        // have to update the current javadoc.
        if (LAST_SELECTION != null && LAST_SELECTION.length == 1) {
            // System.out.println("run modifyJavaDoc for element " + badListLastSelectedIndex);
            //check for no resolved
            if(!(badModel.getElementAt(0) instanceof AutoCommenter.Element))
                return;

            AutoCommenter.Element element = (AutoCommenter.Element) findLastObject();
            if (element != null && element.isValid() && badList.isEnabled()) {
                modifyJavaDoc(element);
            } else {
                badList.setEnabled(false);
                DialogDisplayer.getDefault().notify(
                        new NotifyDescriptor.Message(
                                NbBundle.getMessage(AutoCommentPanel.class, "MSG_IvalidSource"),
                                NotifyDescriptor.WARNING_MESSAGE));
                return;
            }
        }
          
        if ( sel < 0 ) {
            LAST_SELECTION = null;
            errorListBox.setModel(EMPTY_MODEL);
            defaultButton.setEnabled( false );
            sourceButton.setEnabled( false );
            classTextField.setText( "" ); // NOI18N
            javaDocEditor.clear();
            javaDocEditor.setEnabled(false);
        } else if (isMultiselect) {
            LAST_SELECTION = badList.getSelectedValues();
            errorListBox.setModel(EMPTY_MODEL);
            sourceButton.setEnabled(false);
            classTextField.setText(""); // NOI18N
            javaDocEditor.clear();
            javaDocEditor.setEnabled(false);
            boolean canCorrect = isCorrectable(getSelectedElements());
            defaultButton.setEnabled(canCorrect);
        } else {
            //check for no resolved
            if( !(badModel.getElementAt(0) instanceof AutoCommenter.Element) ) {
                LAST_SELECTION = null;
                return;
            }
            LAST_SELECTION = badList.getSelectedValues();

            AutoCommenter.Element element = (AutoCommenter.Element) LAST_SELECTION[0];
            String dcName = element.getDescriptor().getDeclaringClassName();
            if (dcName == null) {
                dcName = element.getDescriptor().getName();
            }
            classTextField.setText(dcName);
            
            defaultButton.setEnabled( element.isCorrectable() );
            sourceButton.setEnabled( true );
            javaDocEditor.setEnabled( true );
            
            errorListBox.setModel( element.getErrorList() );
            showCommentEditor(element);
        }
    }
    
    /** gets array of selected elements from the list model or empty array;
     *  it should be called from EDT only.
     */
    private AutoCommenter.Element[] getSelectedElements() {
        if(!(badList.getModel().getElementAt(0) instanceof AutoCommenter.Element)) {
            return new AutoCommenter.Element[0];
        }
        Object[] objs = badList.getSelectedValues();
        AutoCommenter.Element[] els = new AutoCommenter.Element[objs.length];
        for (int i = 0; i < objs.length; i++) {
            els[i] = (AutoCommenter.Element) objs[i];
        }
        return els;
    }
    
    /** returns true in case all elements are correctable */
    private static boolean isCorrectable(AutoCommenter.Element[] els) {
        assert els != null;
        for (int i = 0; i < els.length; i++) {
            if (!els[i].isCorrectable() || !els[i].isValid()) {
                return false;
            }
        }
        return els.length > 0;
    }
    
    void setAutoCommenter( AutoCommenter autoCommenter ) {
        if (this.autoCommenter != null) {
            this.autoCommenter.removeAutoCommentChangeListener(this);
        }
        this.autoCommenter = autoCommenter;
        if (this.autoCommenter != null) {
            resolveMask();
            activate();
        } else {
            this.LAST_SELECTION = null;
        }
    }
    
    /**
     * initialize auto commenter
     */ 
    public void activate() {
        if (this.autoCommenter == null) return;
        try{
            this.autoCommenter.addAutoCommentChangeListener(this);
            resetState();
        } catch(java.util.TooManyListenersException tooEx){
            ErrorManager.getDefault().notify(tooEx);
        }
    }
    
    /**
     * deactivate auto commenter
     */ 
    public void deactivate() {
        if (this.autoCommenter == null) return;
        this.autoCommenter.removeAutoCommentChangeListener(this);
        updateForClosing();
    }
    
    private void resetState() {
        if (this.autoCommenter == null) return;
        resetingAll = true;
        badList.getSelectionModel().removeListSelectionListener(this);
        badList.setModel( WAIT_MODEL );
        autoCommenter.refreshFromSource();
    }
    
    private void resolveMask() {
        modifierMask = 0;
        errorMask = 0;
        
        if ( publicButton.isSelected() )
            modifierMask |= Modifier.PUBLIC;
        if ( protectedButton.isSelected() )
            modifierMask |= Modifier.PROTECTED;
        if ( privateButton.isSelected() )
            modifierMask |= Modifier.PRIVATE;
        
        if ( okButton.isSelected() )
            errorMask |= AutoCommenter.JDC_OK;
        if ( errButton.isSelected() )
            errorMask |= AutoCommenter.JDC_ERROR;
        if ( missButton.isSelected() )
            errorMask |= AutoCommenter.JDC_MISSING;
        
        DocumentationSettings ds = ((DocumentationSettings)SharedClassObject.findObject(DocumentationSettings.class, true));
        
        ds.setAutocommentModifierMask( modifierMask );
        ds.setAutocommentPackage( packageButton.isSelected() );
        ds.setAutocommentErrorMask( errorMask );
        
        
    }

    private void refreshState(){
        resolveMask();
        resetState();
    }    

    private void replaceModel(ListModel lm) {
        updatingBadList = true;
        resetingAll = false;
        ListSelectionModel lsm = badList.getSelectionModel();
        lsm.removeListSelectionListener(this);
        badList.setEnabled(true);
        badList.setModel(lm);
        lsm.addListSelectionListener(this);

        errorListBox.setModel( EMPTY_MODEL );
        updatingBadList = false;

        int[] lasts = findIndicies(lm, LAST_SELECTION);
        LAST_SELECTION = null;
        if (lasts != null && lasts.length > 0) {
            badList.setSelectedIndices(lasts);
        } else {
            elementSelection(new ListSelectionEvent(lm, -1, -1, false));
        }
    }

    /**
     * finds indicies of items in the listmodel
     * @param lm model where to search
     * @param items what search
     * @return indicies of items in the listmodel
     */
    private static int[] findIndicies(ListModel lm, Object[] items) {
        int[] indecies = null;
        if (items != null) {
            indecies = new int[items.length];
            int count = 0;
            for (int i = 0; i < lm.getSize(); i++) {
                Object el = lm.getElementAt(i);
                for (int j = 0; j < items.length; j++) {
                    Object last = items[j];
                    if (last.equals(el)) {
                        indecies[count++] = i;
                        break;
                    }
                }
            }

            if (count != items.length) {
                int[] temp = indecies;
                indecies = new int[count];
                for (int i = 0; i < indecies.length; i++) {
                    indecies[i] = temp[i];
                }
            }
        }
        return indecies;
    }

    private Object findLastObject() {
        ListModel lm = badList.getModel();
        if (LAST_SELECTION != null && LAST_SELECTION.length == 1) {
            for (int i = 0; i < lm.getSize(); i++) {
                Object el = lm.getElementAt(i);
                    if (LAST_SELECTION[0].equals(el)) {
                        return el;
                    }
            }
        }
        return null;
    }

    /** customize ui according to stored settings
     */
    public void resolveButtonState() {
        
        DocumentationSettings ds = ((DocumentationSettings)SharedClassObject.findObject(DocumentationSettings.class, true));
        
        final int modifierMask = ds.getAutocommentModifierMask();
        final boolean pckg = ds.getAutocommentPackage();
        final int errorMask = ds.getAutocommentErrorMask();
        
        publicButton.setSelected( (modifierMask & Modifier.PUBLIC) != 0 );
        protectedButton.setSelected( (modifierMask & Modifier.PROTECTED) != 0 );
        privateButton.setSelected( (modifierMask & Modifier.PRIVATE) != 0 );
        packageButton.setSelected( pckg );
        
        okButton.setSelected( ( errorMask & AutoCommenter.JDC_OK ) != 0 );
        errButton.setSelected( ( errorMask & AutoCommenter.JDC_ERROR ) != 0 );
        missButton.setSelected( ( errorMask & AutoCommenter.JDC_MISSING) != 0 );
    }
    
    
    // Implementation of ListSelectionListener
    /**
     */
    public void valueChanged(final ListSelectionEvent evt) {
        elementSelection( evt );
    }
    
    // implementation of AutoCommenter.AutoCommentChangeListener
    public void listChanged() {
        final ListModel lm = autoCommenter.prepareListModel(modifierMask, packageButton.isSelected(), errorMask);
        EventQueue.invokeLater(new Runnable() {
            public void run() {
                replaceModel(lm);
            }
        });
    }

    public void elementUpdated(final AutoCommenter.Element el) {
        if (resetingAll) return;
        EventQueue.invokeLater(new Runnable() {
            public void run() {
                DefaultListModel badModel = (DefaultListModel) badList.getModel();
                int index = badModel.indexOf(el);
                if (index < 0) return;
                
                boolean reselect = false;
                int sel = badList.getSelectedIndex();
                try {
                    updatingBadList = true;
                    if (AutoCommenter.acceptElement(el, modifierMask, packageButton.isSelected(), errorMask)) {
                        badModel.setElementAt(el, index);
                    } else {
                        reselect = true;
                        badModel.removeElement(el);
                    }
                } finally {
                    updatingBadList = false;
                }
                if (reselect && sel == index) {
                    // updated element was filtered out of the list so we need to select the next element
                    int size = badModel.getSize();
                    LAST_SELECTION = null;
                    if (size == 0) {
                        elementSelection(new ListSelectionEvent(badModel, -1, -1, false));
                    } else {
                        sel = (sel >= size)? size - 1: sel;
                        badList.setSelectedIndex(sel);
                    }
                } else if (!reselect && sel == index) {
                    // in case auto correct is called; do not store javadoc but refresch ui components
                    LAST_SELECTION = null;
                    elementSelection(new ListSelectionEvent(badModel, sel, sel, false));
                }
            }
        });
    }


}
