/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import java.lang.reflect.InvocationTargetException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.beans.PropertyEditor;

import org.openide.nodes.*;
import org.openide.ErrorManager;
import org.openide.src.JavaDoc;
import org.netbeans.modules.java.ui.nodes.FilterSourceNodeFactory;
import org.netbeans.jmi.javamodel.*;

import javax.jmi.reflect.JmiException;
import org.netbeans.modules.javacore.api.JavaModel;


/** This FilterFactory descendant adds the JavaDoc property to every Method, Constructor, Field and
 * class node create for JavaDataObjects
 *
 * @author Petr Hrebejk
 */

public class JavaDocPropertySupportFactory extends FilterSourceNodeFactory {
    
    private static final String PROP_JAVADOCCOMMENT = "javadocComment"; // NOI18N
        
    public Node createMethodNode(Method element) {
        Node node = super.createMethodNode( element );
        JavaDocPropertySupportFactory.addJavaDocProperty( node );
        return node;
    }

    public Node createConstructorNode(Constructor element) {
        Node node = super.createConstructorNode( element );
        JavaDocPropertySupportFactory.addJavaDocProperty( node );
        return node;
    }

    public Node createFieldNode(Field element) {
        Node node = super.createFieldNode( element );
        JavaDocPropertySupportFactory.addJavaDocProperty( node );
        return node;
    }

    public Node createClassNode(final JavaClass element) {
        Node node = super.createClassNode( element );
        JavaDocPropertySupportFactory.addJavaDocProperty( node );
        return node;
    }

    public Node createAnnotationTypeMethodNode(Attribute element) {
        Node node = super.createAnnotationTypeMethodNode(element);
        JavaDocPropertySupportFactory.addJavaDocProperty( node );
        return node;
    }

    public Node createAnnotationTypeNode(AnnotationType element) {
        Node node = super.createAnnotationTypeNode(element);
        JavaDocPropertySupportFactory.addJavaDocProperty( node );
        return node;
    }

    public Node createEnumConstantNode(EnumConstant element) {
        Node node = super.createEnumConstantNode(element);
        JavaDocPropertySupportFactory.addJavaDocProperty( node );
        return node;
    }

    public Node createEnumNode(JavaEnum element) {
        Node node = super.createEnumNode(element);
        JavaDocPropertySupportFactory.addJavaDocProperty( node );
        return node;
    }
    // UTILITY FUNCTIONS ------------------------------------------------------------------------------

    /** Create a node property for javadoc comment for class element
    * @param canW if <code>false</code>, property will be read-only
    * @return the property
    */ 
    private static Node.Property createJavaDocProperty(boolean canW, final Node node ) {
        JavaDocPropertySupport prop = new JavaDocPropertySupport(PROP_JAVADOCCOMMENT, JavaDoc.class, canW) {

            private AutoCommenter.Element acElement;
            private Reference editorRef;
            
            private AutoCommenter.Element getCommentable() throws InvocationTargetException {
                if (acElement == null) {
                    ClassMember el = (ClassMember) node.getLookup().lookup(ClassMember.class);
                    if (el == null)
                      throw new IllegalStateException("ClassMember missing in lookup: " + node); // NOI18N
                    try {
                        JavaModel.getJavaRepository().beginTrans(false);
                        try {
                            acElement = AutoCommenter.createAutoCommenterElement(el);
                        } finally {
                            JavaModel.getJavaRepository().endTrans();
                        }
                    } catch (JmiException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                return acElement;
            }
            
            public Object getValue() throws
                    IllegalAccessException, InvocationTargetException {
                
                return getCommentable().getJavaDoc();
            }

            // Sets the value
            public void setValue(Object val) throws IllegalArgumentException, 
                    IllegalAccessException, InvocationTargetException {
            
                super.setValue(val);
                if (!(val instanceof JavaDoc))
                    throw new IllegalArgumentException("val: " + val); //NOI18N

                try {
                    JavaModel.getJavaRepository().beginTrans(true);
                    boolean fail = true;
                    try {
                        getCommentable().setJavaDoc((JavaDoc) val);
                        fail = false;
                    } finally {
                        JavaModel.getJavaRepository().endTrans(fail);
                    }
                } catch (JmiException e) {
                    throw new InvocationTargetException(e);
                }
            }
            
            public PropertyEditor getPropertyEditor() {
                try {
                    PropertyEditor editor = editorRef == null? null: (PropertyEditor) this.editorRef.get();
                    if (editor == null) {
                        AutoCommenter.Element commentable = getCommentable();
                        editor = new JavaDocEditor(commentable);
                        editorRef = new SoftReference(editor);
                    }
                    return editor;
                } catch (InvocationTargetException e) {
                    ErrorManager.getDefault().notify(ErrorManager.WARNING, e.getCause());
                    return null;
                }
            }
        
        };

        return prop;
    }




    /** Adds JavaDoc property to node
     */

    private static void addJavaDocProperty(final Node node) {

        // PENDING: THIS IS A WORKAROUND FOR ADDING NEW PROPERTIES ONLY
        //          TO JAVA NODES NOT TO CLAZZ NODES

        Node.PropertySet [] ps = node.getPropertySets();

        for ( int i = 0; i < ps.length; i++ ) {
            if ( ps[i].getName().equals( Sheet.PROPERTIES ) && ps[i] instanceof Sheet.Set ) {
                ((Sheet.Set)ps[i]).put(createJavaDocProperty( true, node ));
            }
        }
    }


}
