/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import javax.swing.*;

import org.openide.src.JavaDocTag;
import org.openide.src.JavaDocSupport;
import org.openide.util.Utilities;
import org.netbeans.jmi.javamodel.*;

public class NewTagDialog extends javax.swing.JPanel implements JavaTagNames {

    private ButtonGroup bgroup;
    private JavaDocTag result = null;

    private String TAG_CUSTOM = "@"; // NOI18N

    /** Initializes the Form */
    public NewTagDialog(ClassMember element ) {
        initComponents ();

        bgroup = new ButtonGroup();

        bgroup.add( authorRadioButton );
        authorRadioButton.getModel().setActionCommand( TAG_AUTHOR );
        authorRadioButton.setVisible( false );
        authorRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.authorRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( deprecatedRadioButton );
        deprecatedRadioButton.getModel().setActionCommand( TAG_DEPRECATED );
        deprecatedRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.deprecatedRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( paramRadioButton );
        paramRadioButton.getModel().setActionCommand( TAG_PARAM );
        paramRadioButton.setVisible( false );
        paramRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.paramRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( returnRadioButton );
        returnRadioButton.getModel().setActionCommand( TAG_RETURN );
        returnRadioButton.setVisible( false );
        returnRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.returnRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( seeRadioButton );
        seeRadioButton.getModel().setActionCommand( TAG_SEE );
        seeRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.seeRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( serialRadioButton );
        serialRadioButton.getModel().setActionCommand( TAG_SERIAL );
        serialRadioButton.setVisible( false );
        serialRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.serialRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( serialDataRadioButton );
        serialDataRadioButton.getModel().setActionCommand( TAG_SERIALDATA );
        serialDataRadioButton.setVisible( false );
        serialDataRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.serialDataRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( serialFieldRadioButton );
        serialFieldRadioButton.getModel().setActionCommand( TAG_SERIALFIELD );
        serialFieldRadioButton.setVisible( false );
        serialFieldRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.serialFieldRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( sinceRadioButton );
        sinceRadioButton.getModel().setActionCommand( TAG_SINCE );
        sinceRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.sinceRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( throwsRadioButton );
        throwsRadioButton.getModel().setActionCommand( TAG_THROWS );
        throwsRadioButton.setVisible( false );
        throwsRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.throwsRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( versionRadioButton );
        versionRadioButton.getModel().setActionCommand( TAG_VERSION );
        versionRadioButton.setVisible( false );
        versionRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.versionRadioButton_Mnemonic").charAt(0));  // NOI18N

        bgroup.add( customRadioButton );
        customRadioButton.getModel().setActionCommand( TAG_CUSTOM );
        customRadioButton.setMnemonic(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("NewTagDialog.customRadioButton_Mnemonic").charAt(0));  // NOI18N

        setBounds(Utilities.findCenterBounds(getSize()));

        if ( element instanceof CallableFeature ) {
            paramRadioButton.setVisible( true );
            returnRadioButton.setVisible( true );
            serialDataRadioButton.setVisible( true );
            throwsRadioButton.setVisible( true );
        }
        else if ( element instanceof Field || element instanceof Attribute) {
            serialRadioButton.setVisible( true );
            serialFieldRadioButton.setVisible( true );
        }
        if ( element instanceof JavaClass ) {
            authorRadioButton.setVisible( true );
            versionRadioButton.setVisible( true );
        }

        initAccessibility();
        /*
        getRootPane().setDefaultButton(okButton);

        javax.swing.InputMap im = getRootPane().getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        im.put(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0), null);
         */
    }

    private void initAccessibility()
    {
        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialogA11yName"));  // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialogA11yDesc"));  // NOI18N
        customTextField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.customTextField.textA11yName"));  // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel2 = new javax.swing.JPanel();
        authorRadioButton = new javax.swing.JRadioButton();
        deprecatedRadioButton = new javax.swing.JRadioButton();
        paramRadioButton = new javax.swing.JRadioButton();
        returnRadioButton = new javax.swing.JRadioButton();
        seeRadioButton = new javax.swing.JRadioButton();
        serialRadioButton = new javax.swing.JRadioButton();
        serialDataRadioButton = new javax.swing.JRadioButton();
        serialFieldRadioButton = new javax.swing.JRadioButton();
        sinceRadioButton = new javax.swing.JRadioButton();
        throwsRadioButton = new javax.swing.JRadioButton();
        versionRadioButton = new javax.swing.JRadioButton();
        customRadioButton = new javax.swing.JRadioButton();
        customTextField = new javax.swing.JTextField();

        FormListener formListener = new FormListener();

        setLayout(new java.awt.BorderLayout());

        addKeyListener(formListener);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(8, 8, 8, 8)));
        authorRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.authorRadioButton.text"));
        authorRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.authorRadioButton.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(authorRadioButton, gridBagConstraints);

        deprecatedRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.deprecatedRadioButton.text"));
        deprecatedRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.deprecatedRadioButton.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(deprecatedRadioButton, gridBagConstraints);

        paramRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.paramRadioButton.text"));
        paramRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.paramRadioButton.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(paramRadioButton, gridBagConstraints);

        returnRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.returnRadioButton.text"));
        returnRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.returnRadioButton.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(returnRadioButton, gridBagConstraints);

        seeRadioButton.setSelected(true);
        seeRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.seeRadioButton.text"));
        seeRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.seeRadioButton.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(seeRadioButton, gridBagConstraints);

        serialRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.serialRadioButton.text"));
        serialRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.serialRadioButton.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(serialRadioButton, gridBagConstraints);

        serialDataRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.serialDataRadioButton.text"));
        serialDataRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.serialDataRadioButton.textA11yDesc"));
        serialDataRadioButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(serialDataRadioButton, gridBagConstraints);

        serialFieldRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.serialFieldRadioButton.text"));
        serialFieldRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.serialFieldRadioButton.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(serialFieldRadioButton, gridBagConstraints);

        sinceRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.sinceRadioButton.text"));
        sinceRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.sinceRadioButton.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(sinceRadioButton, gridBagConstraints);

        throwsRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.throwsRadioButton.text"));
        throwsRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.throwsRadioButton.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(throwsRadioButton, gridBagConstraints);

        versionRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.versionRadioButton.text"));
        versionRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.versionRadioButton.textA11yDesc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(versionRadioButton, gridBagConstraints);

        customRadioButton.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/javadoc/comments/Bundle").getString("NewTagDialog.customRadioButton.text"));
        customRadioButton.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.customRadioButton.textA11yDesc"));
        customRadioButton.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(customRadioButton, gridBagConstraints);

        customTextField.setToolTipText(org.openide.util.NbBundle.getBundle(NewTagDialog.class).getString("ACS_NewTagDialog.customTextField.textA11yDesc"));
        customTextField.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(customTextField, gridBagConstraints);

        add(jPanel2, java.awt.BorderLayout.CENTER);

    }

    // Code for dispatching events from components to event handlers.

    private class FormListener implements java.awt.event.ActionListener, java.awt.event.KeyListener {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            if (evt.getSource() == serialDataRadioButton) {
                NewTagDialog.this.serialDataRadioButtonActionPerformed(evt);
            }
            else if (evt.getSource() == customRadioButton) {
                NewTagDialog.this.customRadioButtonActionPerformed(evt);
            }
            else if (evt.getSource() == customTextField) {
                NewTagDialog.this.customTextFieldActionPerformed(evt);
            }
        }

        public void keyPressed(java.awt.event.KeyEvent evt) {
            if (evt.getSource() == NewTagDialog.this) {
                NewTagDialog.this.formKeyPressed(evt);
            }
        }

        public void keyReleased(java.awt.event.KeyEvent evt) {
        }

        public void keyTyped(java.awt.event.KeyEvent evt) {
        }
    }
    // </editor-fold>//GEN-END:initComponents

    private void formKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_formKeyPressed
        if (evt.getKeyCode() == java.awt.event.KeyEvent.VK_ESCAPE)
        {
            result = null;
            closeDialog(null);
        }
    }//GEN-LAST:event_formKeyPressed

    private void serialDataRadioButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_serialDataRadioButtonActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_serialDataRadioButtonActionPerformed

    private void customTextFieldActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_customTextFieldActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_customTextFieldActionPerformed

    private void customRadioButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_customRadioButtonActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_customRadioButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        //dispose ();
    }//GEN-LAST:event_closeDialog


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton authorRadioButton;
    private javax.swing.JRadioButton customRadioButton;
    private javax.swing.JTextField customTextField;
    private javax.swing.JRadioButton deprecatedRadioButton;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JRadioButton paramRadioButton;
    private javax.swing.JRadioButton returnRadioButton;
    private javax.swing.JRadioButton seeRadioButton;
    private javax.swing.JRadioButton serialDataRadioButton;
    private javax.swing.JRadioButton serialFieldRadioButton;
    private javax.swing.JRadioButton serialRadioButton;
    private javax.swing.JRadioButton sinceRadioButton;
    private javax.swing.JRadioButton throwsRadioButton;
    private javax.swing.JRadioButton versionRadioButton;
    // End of variables declaration//GEN-END:variables


    JavaDocTag getResult() {
        if (result != null)
            return result;

        String command = bgroup.getSelection().getActionCommand();
        if ( command.equals( TAG_SEE ) ) {
            result = JavaDocSupport.createSeeTag( command, "" ); // NOI18N
        }
        else if ( command.equals( TAG_PARAM ) ) {
            result = JavaDocSupport.createParamTag( command, "" ); // NOI18N
        }
        else if ( command.equals( TAG_THROWS ) ) {
            result = JavaDocSupport.createThrowsTag( command, "" ); // NOI18N
        }
        else if ( command.equals( TAG_SERIALFIELD ) ) {
            result = JavaDocSupport.createSerialFieldTag( command, " " ); // NOI18N
        }
        else if ( command.equals( TAG_CUSTOM ) ) {
            result = JavaDocSupport.createTag( command + customTextField.getText(), "" ); // NOI18N
        }
        else {
            result = JavaDocSupport.createTag( command, "" ) ; // NOI18N
        }
        return result;
    }

}
