/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import org.openide.ErrorManager;
import org.openide.src.JavaDocTag;
import org.openide.src.JavaDocSupport;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Parameter;

import javax.swing.text.BadLocationException;
import javax.jmi.reflect.JmiException;
import java.util.List;
import java.util.Iterator;
import org.netbeans.modules.javacore.api.JavaModel;

/**
 *
 * @author
 * @version
 */
public class ParamTagPanel extends TagPanel {
    
    private static final String cardName = "CRD_PARAM"; // NOI18N
    
    static final long serialVersionUID =-8780867931455925203L;
    /** Initializes the Form */
    
    public ParamTagPanel( final JavaDocEditorPanel editorPanel ) {
        super( editorPanel );
        
        initComponents();
        initAccessibility();
        jLabel2.setDisplayedMnemonic(org.openide.util.NbBundle.getBundle(ParamTagPanel.class).getString("CTL_ParamTagPanel.jLabel2.text_Mnemonic").charAt(0));  // NOI18N
        jLabel1.setDisplayedMnemonic(org.openide.util.NbBundle.getBundle(ParamTagPanel.class).getString("CTL_ParamTagPanel.jLabel1.text_Mnemonic").charAt(0));  // NOI18N
        
        addHTMLComponent( descriptionTextArea );
        
        editorPanel.registerComponent( descriptionTextArea );
        
        parameterComboBox.getEditor().getEditorComponent().addFocusListener(
        new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                commitTagChange();
            }
        });
    }
    
    public ParamTagPanel( ClassMember element, JavaDocEditorPanel editorPanel ) {
        this( editorPanel );
        setElement( element );
    }
    
    public void setElement( final ClassMember element ) {
        parameterComboBox.removeAllItems();
        if ( element instanceof CallableFeature ) {
            try {
                JavaModel.getJavaRepository().beginTrans(false);
                try {
                    List params = ((CallableFeature) element).getParameters();
                    for (Iterator it = params.iterator(); it.hasNext();) {
                        Parameter param = (Parameter) it.next();
                        parameterComboBox.addItem( param.getName() );
                    }
                } finally {
                    JavaModel.getJavaRepository().endTrans();
                }
            } catch (JmiException e) {
                ErrorManager.getDefault().notify(e);
            }
            parameterComboBox.setSelectedItem( "" ); // NOI18N
        }
    }
    
    private void initAccessibility()
    {
        jLabel2.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(ParamTagPanel.class).getString("ACS_ParamTagPanel.jLabel2.textA11yDesc"));  // NOI18N
        parameterComboBox.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(ParamTagPanel.class).getString("ACS_ParamTagPanel.parameterComboBox.textA11yName"));  // NOI18N
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(ParamTagPanel.class).getString("ACS_ParamTagPanel.jLabel1.textA11yDesc"));  // NOI18N
        descriptionTextArea.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(ParamTagPanel.class).getString("ACS_ParamTagPanel.descriptionTextArea.textA11yName"));  // NOI18N
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel2 = new javax.swing.JLabel();
        parameterComboBox = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        descriptionScrollPane = new javax.swing.JScrollPane();
        descriptionTextArea = new javax.swing.JEditorPane();

        setLayout(new java.awt.GridBagLayout());

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel2.setLabelFor(parameterComboBox);
        jLabel2.setText(org.openide.util.NbBundle.getBundle(ParamTagPanel.class).getString("CTL_ParamTagPanel.jLabel2.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 1);
        add(jLabel2, gridBagConstraints);

        parameterComboBox.setEditable(true);
        parameterComboBox.setMaximumRowCount(4);
        parameterComboBox.setToolTipText(org.openide.util.NbBundle.getBundle(ParamTagPanel.class).getString("ACS_ParamTagPanel.parameterComboBox.textA11yDesc"));
        parameterComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                parameterComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 1, 2, 2);
        add(parameterComboBox, gridBagConstraints);

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel1.setLabelFor(descriptionTextArea);
        jLabel1.setText(org.openide.util.NbBundle.getBundle(ParamTagPanel.class).getString("CTL_ParamTagPanel.jLabel1.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 1);
        add(jLabel1, gridBagConstraints);

        descriptionTextArea.setToolTipText(org.openide.util.NbBundle.getBundle(ParamTagPanel.class).getString("ACS_ParamTagPanel.descriptionTextArea.textA11yDesc"));
        descriptionTextArea.setContentType("text/html");
        descriptionTextArea.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                descriptionTextAreaFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                descriptionTextAreaFocusLost(evt);
            }
        });

        descriptionScrollPane.setViewportView(descriptionTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 1, 2, 2);
        add(descriptionScrollPane, gridBagConstraints);

    }//GEN-END:initComponents
    
    private void descriptionTextAreaFocusGained (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_descriptionTextAreaFocusGained
        enableHTMLButtons( true );
    }//GEN-LAST:event_descriptionTextAreaFocusGained
    
    private void descriptionTextAreaFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_descriptionTextAreaFocusLost
        enableHTMLButtons( false );
        commitTagChange();
    }//GEN-LAST:event_descriptionTextAreaFocusLost
    
    private void parameterComboBoxActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_parameterComboBoxActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_parameterComboBoxActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox parameterComboBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JEditorPane descriptionTextArea;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane descriptionScrollPane;
    // End of variables declaration//GEN-END:variables
    
    void setData(final JavaDocTag tag ) {
        parameterComboBox.setSelectedItem(((JavaDocTag.Param)tag).parameterName());
        String paramComment = ((JavaDocTag.Param)tag).parameterComment().trim();
        if ((paramComment != null) && (! "".equals(paramComment))) {    //NOI18N
            descriptionTextArea.setText( paramComment );
        } else {
            try {
                descriptionTextArea.getDocument().remove(0, descriptionTextArea.getDocument().getLength());
            } catch (BadLocationException e) {
                ErrorManager.getDefault().annotate(e, "Failed to remove the text in the descriptionTextArea."); //NOI18N
            }
        }
    }
    
    JavaDocTag getTag( String tagName ) {
        return JavaDocSupport.createParamTag( tagName,
        parameterComboBox.getEditor().getItem().toString() + " " + // NOI18N
        descriptionTextArea.getText() );
    }
    
    String getCardName() {
        return cardName;
    }
    
    void grabFirstFocus() {
        //parameterComboBox.requestFocus();
        // JHK 9/29/2000 - cause focus to default to description if the name combo box is filled
        if (( parameterComboBox.getSelectedIndex() == -1 && parameterComboBox.getSelectedItem() != null && parameterComboBox.getSelectedItem().equals( "" ) ) || ("".equals(parameterComboBox.getEditor().getItem()))) {    //NOI18N
            parameterComboBox.requestFocus();
        } else {
            descriptionTextArea.requestFocus();
        }
    }
    
}
