/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javadoc.comments;

import java.util.ResourceBundle;
import org.openide.ErrorManager;
import org.openide.src.JavaDocTag;
import org.openide.src.JavaDocSupport;

import javax.swing.text.BadLocationException;

/**
 *
 * @author
 */
public class SerialFieldTagPanel extends TagPanel {

    private static final String cardName = "CRD_SERIAL_FIELD"; // NOI18N


    static final long serialVersionUID =5117666281468847966L;
    /** Initializes the Form */
    public SerialFieldTagPanel( JavaDocEditorPanel editorPanel ) {
        super( editorPanel );

        initComponents ( );
        ResourceBundle b = org.openide.util.NbBundle.getBundle(SerialFieldTagPanel.class);
        jLabel2.setDisplayedMnemonic(b.getString("CTL_SerialFieldTagPanel.jLabel2.text_Mnemonic").charAt(0));  // NOI18N
        jLabel3.setDisplayedMnemonic(b.getString("CTL_SerialFieldTagPanel.jLabel3.text_Mnemonic").charAt(0));  // NOI18N
        jLabel1.setDisplayedMnemonic(b.getString("CTL_SerialFieldTagPanel.jLabel1.text_Mnemonic").charAt(0));  // NOI18N

        editorPanel.registerComponent( descriptionTextArea );
        addHTMLComponent( descriptionTextArea );
        initAccessibility(b);
    }

    private void initAccessibility(ResourceBundle b)
    {
        jLabel2.getAccessibleContext().setAccessibleDescription(b.getString("ACS_SerialFieldTagPanel.jLabel2.textA11yDesc"));  // NOI18N
        nameTextField.getAccessibleContext().setAccessibleName(b.getString("ACS_SerialFieldTagPanel.nameTextField.textA11yName"));  // NOI18N
        jLabel3.getAccessibleContext().setAccessibleDescription(b.getString("ACS_SerialFieldTagPanel.jLabel3.textA11yDesc"));  // NOI18N
        typeTextField.getAccessibleContext().setAccessibleName(b.getString("ACS_SerialFieldTagPanel.typeTextField.textA11yName"));  // NOI18N
        jLabel1.getAccessibleContext().setAccessibleDescription(b.getString("ACS_SerialFieldTagPanel.jLabel1.textA11yDesc"));  // NOI18N
        descriptionTextArea.getAccessibleContext().setAccessibleName(b.getString("ACS_SerialFieldTagPanel.descriptionTextArea.textA11yName"));  // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel2 = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        typeTextField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        descriptionScrollPane = new javax.swing.JScrollPane();
        descriptionTextArea = new javax.swing.JEditorPane();

        setLayout(new java.awt.GridBagLayout());

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel2.setLabelFor(nameTextField);
        jLabel2.setText(org.openide.util.NbBundle.getBundle(SerialFieldTagPanel.class).getString("CTL_SerialFieldTagPanel.jLabel2.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 1);
        add(jLabel2, gridBagConstraints);

        nameTextField.setText("jTextField1");
        nameTextField.setToolTipText(org.openide.util.NbBundle.getBundle(SerialFieldTagPanel.class).getString("ACS_SerialFieldTagPanel.nameTextField.textA11yDesc"));
        nameTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nameTextFieldActionPerformed(evt);
            }
        });
        nameTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                fieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 1, 2, 2);
        add(nameTextField, gridBagConstraints);

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel3.setLabelFor(typeTextField);
        jLabel3.setText(org.openide.util.NbBundle.getBundle(SerialFieldTagPanel.class).getString("CTL_SerialFieldTagPanel.jLabel3.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 1);
        add(jLabel3, gridBagConstraints);

        typeTextField.setText("jTextField2");
        typeTextField.setToolTipText(org.openide.util.NbBundle.getBundle(SerialFieldTagPanel.class).getString("ACS_SerialFieldTagPanel.typeTextField.textA11yDesc"));
        typeTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                typeTextFieldActionPerformed(evt);
            }
        });
        typeTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                fieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 1, 2, 2);
        add(typeTextField, gridBagConstraints);

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel1.setLabelFor(descriptionTextArea);
        jLabel1.setText(org.openide.util.NbBundle.getBundle(SerialFieldTagPanel.class).getString("CTL_SerialFieldTagPanel.jLabel1.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 1);
        add(jLabel1, gridBagConstraints);

        descriptionTextArea.setToolTipText(org.openide.util.NbBundle.getBundle(SerialFieldTagPanel.class).getString("ACS_SerialFieldTagPanel.descriptionTextArea.textA11yDesc"));
        descriptionTextArea.setContentType("text/html");
        descriptionTextArea.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                descriptionTextAreaFocusGained(evt);
            }
            public void focusLost(java.awt.event.FocusEvent evt) {
                descriptionTextAreaFocusLost(evt);
            }
        });

        descriptionScrollPane.setViewportView(descriptionTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 1, 2, 2);
        add(descriptionScrollPane, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void descriptionTextAreaFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_descriptionTextAreaFocusLost
        enableHTMLButtons( false );
		fieldFocusLost( evt );
    }//GEN-LAST:event_descriptionTextAreaFocusLost

    private void descriptionTextAreaFocusGained (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_descriptionTextAreaFocusGained
        enableHTMLButtons( true );
    }//GEN-LAST:event_descriptionTextAreaFocusGained

    private void fieldFocusLost (java.awt.event.FocusEvent evt) {//GEN-FIRST:event_fieldFocusLost

        /*
        if ( evt.getSource() == nameTextField ) {
          System.out.println("UUYUname");
          if ( checkField( nameTextField ) ) {
            return;
          }
    }

        if ( evt.getSource() == typeTextField ) {
          System.out.println("YTYTtypoe");
          if ( checkField( typeTextField ) ) {
            return;
          }
    }
        */

        commitTagChange();
    }//GEN-LAST:event_fieldFocusLost


    private void nameTextFieldActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nameTextFieldActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_nameTextFieldActionPerformed

    private void typeTextFieldActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_typeTextFieldActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_typeTextFieldActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane descriptionScrollPane;
    private javax.swing.JEditorPane descriptionTextArea;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JTextField typeTextField;
    // End of variables declaration//GEN-END:variables

    void setData( JavaDocTag tag ) {
        String fieldName = ((JavaDocTag.SerialField)tag).fieldName();
        nameTextField.setText( fieldName == null ? "" : fieldName ); //NOI18N

        String fieldType = ((JavaDocTag.SerialField)tag).fieldType();
        typeTextField.setText( fieldType == null ? "" : fieldType ); //NOI18N

        String description = ((JavaDocTag.SerialField)tag).description();
        if ((description != null) && (! "".equals(description))) {  //NOI18N
            descriptionTextArea.setText( description );
        } else {
            try {
                descriptionTextArea.getDocument().remove(0, descriptionTextArea.getDocument().getLength());
            } catch (BadLocationException e) {
                ErrorManager.getDefault().annotate(e, "Failed to remove the text in the descriptionTextArea."); //NOI18N
            }
        }

        // descriptionTextArea.setCaretPosition( 0 );
    }

    JavaDocTag getTag( String tagName ) {

		return JavaDocSupport.createSerialFieldTag( tagName,
                nameTextField.getText() + " " + // NOI18N
                typeTextField.getText() + " " + // NOI18N
                descriptionTextArea.getText() );
    }


    String getCardName() {
        return cardName;
    }

    void grabFirstFocus() {
        nameTextField.requestFocus();
    }
}
