/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.junit;

import java.io.File;
import org.apache.tools.ant.module.spi.AutomaticExtraClasspathProvider;
import org.openide.modules.InstalledFileLocator;

/**
 * Makes sure <code>junit.jar</code> is included in Ant's classpath when
 * the JUnit module is enabled.
 * This permits the <code>&lt;junit&gt;</code> task to work.
 * @author Jesse Glick
 */
public class JUnitClasspathProvider implements AutomaticExtraClasspathProvider {
    
    /** Default constructor for lookup. */
    public JUnitClasspathProvider() {}
    
    public File[] getClasspathItems() {
        File junitJar = InstalledFileLocator.getDefault().locate(
            "modules/ext/junit-3.8.1.jar", "org.netbeans.modules.junit", false); // NOI18N
        assert junitJar != null : "Missing junit-3.8.1.jar";
        return new File[] {junitJar};
    }
    
}
