/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.junit.output;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;

/**
 *
 * @author Marian Petras
 */
final class ResultViewOutput implements MultiViewElement {
    
    /** */
    private final ResultDisplayHandler displayHandler;
    /** */
    private ResultPanelOutput visualPanel;
    /** */
    private JComponent toolbar;
    /** */
    private Report report;
    
    /** Creates a new instance of ResultViewOutput */
    ResultViewOutput(ResultDisplayHandler displayHandler) {
        this.displayHandler = displayHandler;
    }
    
    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public void componentActivated() {
        ((ResultPanelOutput) getVisualRepresentation()).requestFocusInWindow();
    }

    public void componentClosed() {
        //PENDING
    }

    public void componentDeactivated() {
        //PENDING
    }

    public void componentHidden() {
        //PENDING
    }

    public void componentOpened() {
        //PENDING
    }

    public void componentShowing() {
        //PENDING
    }

    public Action[] getActions() {
        //PENDING
        return new Action[0];
    }

    public Lookup getLookup() {
        //PENDING
        return Lookup.EMPTY;
    }

    public JComponent getToolbarRepresentation() {
        if (toolbar == null) {
            toolbar = new JPanel();
        }
        return toolbar;
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
    }

    public JComponent getVisualRepresentation() {
        if (visualPanel == null) {
            visualPanel = new ResultPanelOutput(displayHandler);
        }
        return visualPanel;
    }
    
}
