/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.junit.output;

import java.awt.EventQueue;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/**
 *
 * @author Marian Petras
 */
final class ResultViewTree implements MultiViewElement, ChangeListener {
    
    /** */
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];

    /** */
    private final ResultDisplayHandler displayHandler;
    /** */
    private ResultPanelTree visualPanel;
    /** */
    private JComponent toolBar;
    /** */
    private MultiViewElementCallback callback;
    /** */
    private Report report;
    
    /** Creates a new instance of ResultViewTree */
    ResultViewTree(ResultDisplayHandler displayHandler) {
        this.displayHandler = displayHandler;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public void componentActivated() {
        assert EventQueue.isDispatchThread();
        assert visualPanel != null;
        assert callback != null;
        
        showToolBar();
        ((ResultPanelTree) getVisualRepresentation()).requestFocusInWindow();
        
        //PENDING:
        //visualPanel.setChangeListener(this);
        //callback.getTopComponent().setActivatedNodes(
        //        visualPanel.getSelectedNodes());
    }

    public void componentDeactivated() {
        assert EventQueue.isDispatchThread();
        assert visualPanel != null;
        assert callback != null;
        
        //PENDING:
        //visualPanel.setChangeListener(null);
        //callback.getTopComponent().setActivatedNodes(EMPTY_NODE_ARRAY);
    }

    public void componentOpened() {
        //PENDING
    }

    public void componentClosed() {
        //PENDING
    }

    public void componentHidden() {
        hideToolBar();
    }

    public void componentShowing() {
        showToolBar();
    }
    
    /**
     */
    private void showToolBar() {
        if (toolBar != null) {
            toolBar.setVisible(true);
        }
    }
    
    /**
     */
    private void hideToolBar() {
        if (toolBar != null) {
            toolBar.setVisible(false);
        }
    }

    public Action[] getActions() {
        //PENDING
        return new Action[0];
    }

    public Lookup getLookup() {
        //PENDING
        return Lookup.EMPTY;
    }

    public JComponent getToolbarRepresentation() {
        if (toolBar == null) {
            getVisualRepresentation();   //provoke initialization of visualPanel
            toolBar = createToolbar(visualPanel.getFilterButton());
        }
        return toolBar;
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
    }

    public JComponent getVisualRepresentation() {
        if (visualPanel == null) {
            visualPanel = createTreePanel();
        }
        return visualPanel;
    }
    
    public void stateChanged(ChangeEvent e) {
        //PENDING:
        //callback.getTopComponent().setActivatedNodes(
        //        visualPanel.getSelectedNodes());
    }
    
    /**
     */
    private ResultPanelTree createTreePanel() {
        return new ResultPanelTree(displayHandler);
    }
    
    /**
     */
    private JComponent createToolbar(AbstractButton filterButton) {
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new BoxLayout(toolbar, BoxLayout.X_AXIS));
        toolbar.addSeparator();
        toolbar.add(filterButton);
        toolbar.add(Box.createHorizontalGlue());
        
        toolbar.setFocusable(false);
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        
        return toolbar;
    }
    
}
