/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package test;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import junit.framework.AssertionFailedError;
import junit.framework.TestSuite;
import org.netbeans.a11y.AccessibilityTester;
import org.netbeans.a11y.TestSettings;
import org.netbeans.a11y.TextReport;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.jemmy.operators.*;
import org.netbeans.jellytools.*;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.ExplorerOperator;
import org.netbeans.jellytools.NbFrameOperator;
import org.netbeans.jellytools.modules.junit.actions.CreateTestsAction;
import org.netbeans.jellytools.modules.junit.actions.OpenTestAction;
import org.netbeans.jellytools.modules.junit.dialogs.CreateTestsDialogOperator;
import org.netbeans.jellytools.modules.junit.nodes.JUnitNode;
import org.netbeans.jellytools.nodes.FilesystemNode;
import org.netbeans.jellytools.nodes.JavaNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.RepositoryRootNode;
import org.netbeans.jellytools.properties.ComboBoxProperty;
import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jellytools.properties.PropertySheetTabOperator;
import org.netbeans.jellytools.properties.StringProperty;
import org.netbeans.jellytools.util.StringFilter;
import org.netbeans.jemmy.JemmyException;

public class Test extends JellyTestCase {
    
    public Test(String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        staticworkdir = "/opt/sources/nb_all/junit/test/qa-functional/src";
        junit.textui.TestRunner.run(suite());
    }
    
    public static junit.framework.Test suite() {
        TestSuite suite = new NbTestSuite();
        suite.addTest(new Test("testSingleAll"));
        suite.addTest(new Test("testSingleModification"));
        suite.addTest(new Test("testIncludeClasses"));
        suite.addTest(new Test("testIncludePackagePrivateClasses"));
        suite.addTest(new Test("testManyFiles"));
        suite.addTest(new Test("testToNewFS"));
        suite.addTest(new Test("testUpdateMethods"));
        suite.addTest(new Test("testGenerateSuiteFile"));
        suite.addTest(new Test("testGenerateSuitePackage"));
        suite.addTest(new Test("testOpenWrong"));
        suite.addTest(new Test("testOpenPrepare"));
        suite.addTest(new Test("testOpenFile"));
        suite.addTest(new Test("testOpenPackage"));
        suite.addTest(new Test("testOpenMany"));
        suite.addTest(new Test("testA11Y"));
        suite.addTest(new Test("testProperties"));
        suite.addTest(new Test("testExpert"));
        suite.addTest(new Test("testRootSuiteClassName"));
        suite.addTest(new Test("testRunPrepare"));
        suite.addTest(new Test("testPropertiesProperty"));
        suite.addTest(new Test("testRunWrong"));
        suite.addTest(new Test("testRunClass"));
        suite.addTest(new Test("testRunTest"));
        suite.addTest(new Test("testRunDirectory"));
        suite.addTest(new Test("testExternalExecution"));
        suite.addTest(new Test("testRunner"));
//        suite.addTest(new Test("testShowCreateDialog")); // always fail when run from command line
        suite.addTest(new Test("testPropertyChanged"));
        return suite;
    }
    
    public static final String TEST_CREATED = Bundle.getString("org.netbeans.modules.junit.Bundle", "MSG_StatusBar_CreateTests_Finished");
    public static final String TEST = Bundle.getString("org.netbeans.modules.junit.Bundle", "PROP_test_classname_suffix_default_value");
    public static final String SUITE = Bundle.getString("org.netbeans.modules.junit.Bundle", "PROP_suite_classname_suffix_default_value");
    public static final String CONFIRM_OBJECT_DELETION = Bundle.getString("org.netbeans.core.windows.Bundle", "MSG_ConfirmDeleteObjectTitle");
    public static final String CLOSE = Bundle.getString("org/netbeans/core/Bundle", "CLOSED_OPTION_CAPTION");
    public static final String ERROR = Bundle.getString("org.openide.Bundle", "NTF_ErrorTitle");
    public static final String PROCESSES = Bundle.getString("org.netbeans.core.execution.Bundle", "Processes");
    public static final String COMPILATION = Bundle.getString("org.openide.compiler.Bundle", "CTL_CompilationTask");
    public static final String CREATE_TESTS_DIALOG = Bundle.getString("org.netbeans.modules.junit.Bundle", "JUnitCfgOfCreate.Title");
    
    public static final String TRUE = Bundle.getString("org.netbeans.modules.junit.Bundle", "LBL_true");
    public static final String FALSE = Bundle.getString("org.netbeans.modules.junit.Bundle", "LBL_false");
    
    public static final String JUNIT_SETTINGS = Bundle.getString("org.netbeans.modules.junit.Bundle", "org-netbeans-modules-junit-JUnitSettings.settings");
    public static final String TESTING_JUNIT_SETTINGS = "Testing|" + JUNIT_SETTINGS;
    
    public static final String PROPERTIES = Bundle.getString("org.openide.nodes.Bundle", "Properties");
    public static final String EXPERT = Bundle.getString("org.openide.nodes.Bundle", "Expert");
    
    public static final String JAVA_BEANS_JAVA_BEAN = Bundle.getString("org.netbeans.modules.beans.Bundle", "Templates/Beans") + "|" + Bundle.getString("org.netbeans.modules.beans.Bundle", "Templates/Beans/Bean.java");
    
    public static final String INTERNAL_EXECUTION = Bundle.getString("org.netbeans.modules.junit.Bundle", "LBL_executor_internal");
    public static final String EXTERNAL_EXECUTION = Bundle.getString("org.netbeans.modules.junit.Bundle", "LBL_executor_external");

    public static final String PROPERT = Bundle.getString("org.netbeans.core.Bundle", "CTL_FMT_LocalProperties", new Object[] { new Integer (1), ""}).substring (0, 7);
    
    static String staticworkdir = null;
    PrintStream out;
    PrintStream log;
    ExplorerOperator exp;
    FilesystemNode testfsnode;
    String fs;
    StringFilter javafilefilter;
    
    protected void setUp() throws IOException {
        out = getRef ();
        log = getLog ();
        closeAllProperties ();
        exp = new ExplorerOperator ();
        String workdir = (staticworkdir != null) ? staticworkdir : "src";
        testfsnode = new FilesystemNode (exp.repositoryTab().tree (), workdir);
        fs = testfsnode.getText();
        javafilefilter = new StringFilter ();
        javafilefilter.addReplaceFilter("Created on ", "", "Created on <DATE>");
        javafilefilter.addReplaceFilter("@author ", "", "@author <AUTHOR>");
    }
    
    public void closeAllWindows (String titlepart) {
        ArrayList al = new ArrayList ();
        for (int a = 0;; a ++) {
            NbFrameOperator fr = NbFrameOperator.find(titlepart, a);
            if (fr == null)
                break;
            getLog ().println ("Found frame: " + fr.getTitle ());
            al.add (fr);
        }
        for (int a = 0; a < al.size (); a ++) {
            NbFrameOperator fr = (NbFrameOperator) al.get (a);
            getLog ().println ("Closing frame: " + fr.getTitle ());
            if (fr.isShowing ()) try {
                fr.close();
            } catch (JemmyException e) {
                getLog ().println ("Exception while closing frame: " + fr.getTitle ());
                e.printStackTrace(getLog ());
            }
            int b = 60;
            while (b > 0  &&  fr.isShowing()) {
                try { Thread.sleep (1000); } catch (InterruptedException e) {}
                b --;
            }
            if (b <= 0)
                getLog ().println ("Timeout while closing frame: " + fr.getTitle ());
        }
    }
    
    public void closeAllProperties() {
        closeAllWindows (PROPERT);
    }
    
    public void waitIsShowing (ComponentOperator comp) {
        for (int a = 0; a < 60; a ++) {
            if (!comp.isShowing())
                return;
            try { Thread.sleep (1000); } catch (InterruptedException e) { break; }
        }
        throw new AssertionFailedError ("Timeout: waitIsShowing: ComponentOperator: " + comp);
    }
    
    public void processCreateTestsDialog (String commands) {
        MainWindowOperator.getDefault ().setStatusText("");
        CreateTestsDialogOperator dia = new CreateTestsDialogOperator ();
        dia.verify ();
        processCreateTestsDialogCore (dia, commands);
        dia.ok ();
        dia.waitClosed();
        MainWindowOperator.getDefault ().waitStatusText(TEST_CREATED);
    }
    
    public void processCreateTestsDialogCore (CreateTestsDialogOperator dia, String commands) {
        boolean _public = false, _protected = false, _package = false;
        boolean _abstract = false, _exception = false, _private = false;
        boolean _comments = false, _javadoc = false;
        boolean _default = false, _suite = false;
        boolean _show = dia.cbShowCreateTestsConfigurationDialog().isSelected();
        StringTokenizer st = new StringTokenizer (commands, " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().toLowerCase();
            if ("methods".equals (token))
                _public = _protected = _package = true;
            else if ("public".equals (token))
                _public = true;
            else if ("protected".equals (token))
                _protected = true;
            else if ("packagemethods".equals (token))
                _package = true;
            else if ("classes".equals (token))
                _abstract = _exception = _private = true;
            else if ("abstract".equals (token))
                _abstract = true;
            else if ("exception".equals (token))
                _exception = true;
            else if ("packageclasses".equals (token))
                _private = true;
            else if ("doc".equals (token))
                _comments = _javadoc = true;
            else if ("comments".equals (token))
                _comments = true;
            else if ("javadoc".equals (token))
                _javadoc = true;
            else if ("body".equals (token))
                _default = _suite = true;
            else if ("default".equals (token))
                _default = true;
            else if ("suite".equals (token))
                _suite = true;
            else if ("show".equals (token))
                _show = true;
            else
                throw new AssertionFailedError ("Invalid token in commands: Token: " + token + " Commands: " + commands);
        }
        dia.selectFileSystem(fs);
        dia.selectSuiteClass(CreateTestsDialogOperator.ITEM_SIMPLEJUNITTEST);
        dia.selectTestClass(CreateTestsDialogOperator.ITEM_SIMPLEJUNITTEST);
        dia.checkPublicMethods(_public);
        dia.checkProtectedMethods(_protected);
        dia.checkPackageMethods(_package);
        dia.checkIncludeAbstractClasses(_abstract);
        dia.checkIncludeExceptionClasses(_exception);
        dia.checkIncludePackagePrivateClasses(_private);
        dia.checkComments(_comments);
        dia.checkJavaDoc(_javadoc);
        dia.checkDefaultBodies(_default);
        dia.checkGenerateSuites(_suite);
        dia.checkShowCreateTestsConfigurationDialog(_show);
    }
    
    public String processCreateTests (boolean directory, String file, String commands) {
        out.println ("==== Processing file: " + file + " ---- Commands: " + commands);
        JUnitNode node = new JUnitNode (exp.repositoryTab().tree (), fs + "|" + file);
        node.createTests();
        processCreateTestsDialog (commands);
        if (!directory) {
            file += TEST;
        } else {
            String s = node.getText ();
            if (s != null  &&  s.length() > 0)
                s = s.substring (0, 1).toUpperCase() + s.substring (1);
            file += "|" + s + SUITE;
        }
        return file;
    }
    
    public void processCreateTests (String[] file, String commands) {
        String filestr = "";
        if (file != null)
            for (int a = 0; a < file.length; a ++) {
                if (a != 0)
                    filestr += ",";
                filestr += file[a];
            }
        out.println ("==== Processing files: [" + filestr + "] ---- Commands: " + commands);
        Node[] nodes = new Node[(file != null) ? file.length : 0];
        for (int a = 0; a < nodes.length; a ++)
            nodes[a] = new JUnitNode (exp.repositoryTab().tree (), fs + "|" + file[a]);
        new CreateTestsAction ().performPopup (nodes);
        processCreateTestsDialog (commands);
    }
    
    public String editFile (String file, String tofind, String toinsert) {
        //MainWindowOperator.getDefault ().setStatusText ("");
        JavaNode node = new JavaNode (exp.repositoryTab().tree (), fs + "|" + file);
        node.open();
        //MainWindowOperator.getDefault ().waitStatusText("Opening " + node.getText ());
        EditorOperator eo = new EditorOperator (new EditorWindowOperator (), node.getText ());
        out.println ("==== Editing file: " + file + " ---- Panel Name: " + eo.getName());
        eo.setCaretPosition(tofind, false);
        eo.insert(toinsert);
        eo.waitModified(true);
        eo.close(true);
        waitIsShowing (eo);
        return file;
    }
    
    public String dumpFile (String file) {
        return dumpFile (fs, file);
    }
    
    public String dumpFile (String fs, String file) {
        //MainWindowOperator.getDefault ().setStatusText ("");
        JavaNode node = new JavaNode (exp.repositoryTab().tree (), fs + "|" + file);
        node.open();
        //MainWindowOperator.getDefault ().waitStatusText("Opening " + node.getText ());
        EditorOperator eo = new EditorOperator (new EditorWindowOperator (), node.getText ());
        out.println ("==== Dumping file: " + file + " ---- Panel Name: " + eo.getName());
        javafilefilter.filterLinesToStream(eo.getText (), out);
        eo.close(true);
        waitIsShowing (eo);
        return file;
    }
    
    public void deleteFile (String file) {
        out.println ("==== Deleting file: " + file);
        JavaNode node = new JavaNode (exp.repositoryTab().tree (), fs + "|" + file);
        String nodename = node.getText ();
        Node parent = new Node (exp.repositoryTab ().tree (), node.getParentPath());
        node.delete ();
        NbDialogOperator dia = new NbDialogOperator (CONFIRM_OBJECT_DELETION);
        dia.yes ();
        dia.waitClosed ();
        parent.waitChildNotPresent(nodename);
    }
    
    public void waitNoNode (String file) {
        int i = file.lastIndexOf('|');
        if (i < 0)
            throw new AssertionFailedError ("Could not find parent for file: " + file);
        String parent = file.substring(0, i);
        String child = file.substring (i + 1);
        out.println ("==== Waiting for no node: Parent: " + parent + " Child: " + child);
        new Node (exp.repositoryTab ().tree (), fs + "|" + parent).waitChildNotPresent (child);
    }
    
    public void closeEditor (String file) {
        EditorOperator eo = new EditorOperator (new EditorWindowOperator (), file);
        out.println ("==== Closing file: " + file + " ---- Panel Name: " + eo.getName());
        eo.close();
        waitIsShowing (eo);
    }
    
    public void testA11YDialog (Component component, String title, boolean close) {
        TestSettings ts = new TestSettings ();
        ts.setDefaultSettings();
        ts.tabTraversal = false;
        if (close)
            ts.setCancelLabel(CLOSE);
        AccessibilityTester at = new AccessibilityTester (component, ts);
        at.startTests();
        TextReport tr = new TextReport (at, ts);
        out.println ("==== Testing Component: " + title);
        OutputStreamWriter osw = new OutputStreamWriter (out);
        tr.getReport(osw);
        try { osw.flush (); } catch (IOException e) { e.printStackTrace(); }
    }
    
    public void assertErrorDialog () {
        NbDialogOperator dia = new NbDialogOperator (ERROR);
        dia.ok ();
        dia.waitClosed();
    }
    
    public void waitTestExecutionFinished () {
        waitTestExecutionFinished ("org.netbeans.modules.junit.testrunner.JUnitTestRunner");
    }
    
    public void waitTestExecutionFinished (String executor) {
        try { Thread.sleep (5000); } catch (InterruptedException e) {}
        new Node (exp.runtimeTab ().tree (), PROCESSES).waitChildNotPresent(COMPILATION);
        new Node (exp.runtimeTab ().tree (), PROCESSES).waitChildNotPresent(executor);
        //new Node (exp.runtimeTab ().tree (), PROCESSES + "|<No Processes Running>");
    }
    
    public TermOperator dumpTerm (String shouldcontain) {
        return dumpTerm (Bundle.getString("org.netbeans.core.execution.Bundle", "CTL_ProgramIO", new Object[] {"org.netbeans.modules.junit.testrunner.JUnitTestRunner"}), shouldcontain);
    }
    
    public TermOperator dumpTerm (String title, String shouldcontain) {
        return dumpTerm (out, title, shouldcontain);
    }
    
    public TermOperator dumpTerm (PrintStream stream, String title, String shouldcontain) {
        OutputWindowOperator owo = OutputWindowOperator.invoke ();
        TermOperator to = owo.getTerm(title);
        String str = null;
        for (int a = 0; a < 10; a ++) {
            str = to.getText ();
            if (str != null  &&  str.indexOf (shouldcontain) >= 0) {
                log.println (str);
                javafilefilter.filterLinesToStream(to.getText(), stream);
                return to;
            }
            try { Thread.sleep (1000); } catch (InterruptedException e) {}
        }
        log.println (str);
        throw new AssertionFailedError ("Timeout: Waiting for right term operator content.");
    }
    
    public void closeTerm (TermOperator to) {
        to.close ();
        waitIsShowing(to);
    }
    
    public void testSingleAll() {
        dumpFile (processCreateTests (false, "data|singleall|Class1", "METHODS CLASSES DOC BODY"));
        compareReferenceFiles();
    }
    
    public void testSingleModification () {
        waitNoNode (processCreateTests (false, "data|singlemodify|Class1", ""));
        waitNoNode (processCreateTests (false, "data|singlemodify|Class1", "CLASSES DOC BODY"));
        deleteFile (dumpFile (processCreateTests (false, "data|singlemodify|Class1", "METHODS")));
        deleteFile (dumpFile (processCreateTests (false, "data|singlemodify|Class1", "PUBLIC CLASSES DOC BODY")));
        deleteFile (dumpFile (processCreateTests (false, "data|singlemodify|Class1", "PROTECTED CLASSES DOC BODY")));
        deleteFile (dumpFile (processCreateTests (false, "data|singlemodify|Class1", "PACKAGEMETHODS CLASSES DOC BODY")));
        deleteFile (dumpFile (processCreateTests (false, "data|singlemodify|Class1", "METHODS CLASSES BODY")));
        deleteFile (dumpFile (processCreateTests (false, "data|singlemodify|Class1", "METHODS CLASSES JAVADOC BODY")));
        deleteFile (dumpFile (processCreateTests (false, "data|singlemodify|Class1", "METHODS CLASSES COMMENTS BODY")));
        deleteFile (dumpFile (processCreateTests (false, "data|singlemodify|Class1", "METHODS CLASSES DOC")));
        deleteFile (dumpFile (processCreateTests (false, "data|singlemodify|Class1", "METHODS CLASSES DOC DEFAULT")));
        deleteFile (dumpFile (processCreateTests (false, "data|singlemodify|Class1", "METHODS CLASSES DOC SUITE")));
        compareReferenceFiles();
    }
    
    public void testIncludeClasses () {
        dumpFile (processCreateTests (true, "data|include", "METHODS DOC BODY"));
        waitNoNode ("data|include|ClassAbstract1Test");
        waitNoNode ("data|include|ClassException1Test");
        waitNoNode ("data|include|ClassException2Test");
        waitNoNode ("data|include|ClassIOExceptionTest");
        dumpFile (processCreateTests (true, "data|include", "METHODS DOC ABSTRACT BODY"));
        deleteFile (dumpFile ("data|include|ClassAbstract1Test"));
        waitNoNode ("data|include|ClassException1Test");
        waitNoNode ("data|include|ClassException2Test");
        waitNoNode ("data|include|ClassIOExceptionTest");
        dumpFile (processCreateTests (true, "data|include", "METHODS DOC EXCEPTION BODY"));
        waitNoNode ("data|include|ClassAbstract1Test");
        deleteFile (dumpFile ("data|include|ClassException1Test"));
        deleteFile (dumpFile ("data|include|ClassException2Test"));
        deleteFile (dumpFile ("data|include|ClassIOExceptionTest"));
        dumpFile (processCreateTests (true, "data|include", "METHODS DOC CLASSES BODY"));
        dumpFile ("data|include|ClassAbstract1Test");
        dumpFile ("data|include|ClassException1Test");
        dumpFile ("data|include|ClassException2Test");
        dumpFile ("data|include|ClassIOExceptionTest");
        compareReferenceFiles ();
    }
    
    public void testIncludePackagePrivateClasses () {
        dumpFile (processCreateTests (true, "data|incpacprivate", "METHODS DOC BODY"));
        deleteFile (dumpFile ("data|incpacprivate|ClassPrivate1Test"));
        waitNoNode ("data|incpacprivate|ClassNotPublic1Test");
        waitNoNode ("data|incpacprivate|ClassNotPublic2Test");
        dumpFile (processCreateTests (true, "data|incpacprivate", "METHODS PACKAGECLASSES DOC BODY"));
        dumpFile ("data|incpacprivate|ClassPrivate1Test");
        dumpFile ("data|incpacprivate|ClassNotPublic1Test");
        dumpFile ("data|incpacprivate|ClassNotPublic2Test");
        compareReferenceFiles ();
    }
    
    public void testManyFiles () {
        processCreateTests (new String [] {
            "data|manyfiles|Class1",
            "data|manyfiles|Class2",
            "data|manyfiles|ClassForm",
            "data|manyfiles|rootdir"
        }, "METHODS CLASSES DOC BODY");
        dumpFile ("data|manyfiles|Class1Test");
        dumpFile ("data|manyfiles|Class2Test");
        dumpFile ("data|manyfiles|ClassFormTest");
        waitNoNode ("data|manyfiles|ClassNoGenerateTest");
        dumpFile ("data|manyfiles|rootdir|Class1Test");
        dumpFile ("data|manyfiles|rootdir|Class2Test");
        dumpFile ("data|manyfiles|rootdir|ClassFormTest");
        dumpFile ("data|manyfiles|rootdir|RootdirSuite");
        dumpFile ("data|manyfiles|rootdir|subdir|Class1Test");
        dumpFile ("data|manyfiles|rootdir|subdir|Class2Test");
        waitNoNode ("data|manyfiles|rootdir|subdir|ClassNoMethodTest");
        dumpFile ("data|manyfiles|rootdir|subdir|SubdirSuite");
        compareReferenceFiles();
    }
    
    public void testToNewFS () {
        String newfs = fs + File.separator + "data" + File.separator + "tonewfs";
        new RepositoryTabOperator ().mountLocalDirectoryAPI(newfs);
        FilesystemNode newfsnode = new FilesystemNode (exp.repositoryTab ().tree (), newfs);

        new JUnitNode (exp.repositoryTab ().tree (), fs + "|data|tonewfs").createTests();
        CreateTestsDialogOperator dia = new CreateTestsDialogOperator ();
        dia.verify ();
        processCreateTestsDialogCore (dia, "METHODS CLASSES DOC BODY");
        dia.selectFileSystem(newfs);
        dia.ok ();
        dia.waitClosed();
        MainWindowOperator.getDefault ().waitStatusText("Tests created.");
        
        dumpFile (newfs, "data|tonewfs|TonewfsSuite");
        dumpFile (newfs, "data|tonewfs|Class1Test");
        newfsnode.unmount();
        new RepositoryRootNode (exp.repositoryTab().tree ()).waitChildNotPresent(newfs);
        compareReferenceFiles();
    }
    
    public void testUpdateMethods () {
        waitNoNode (processCreateTests (false, "data|updatemethods|ClassMethods", ""));
        dumpFile (processCreateTests (false, "data|updatemethods|ClassMethods", "PUBLIC CLASSES DOC BODY"));
        dumpFile (processCreateTests (false, "data|updatemethods|ClassMethods", "PROTECTED CLASSES DOC BODY"));
        dumpFile (processCreateTests (false, "data|updatemethods|ClassMethods", "PACKAGEMETHODS CLASSES DOC BODY"));
        dumpFile (processCreateTests (false, "data|updatemethods|ClassDoc", "PUBLIC CLASSES JAVADOC BODY"));
        dumpFile (processCreateTests (false, "data|updatemethods|ClassDoc", "PROTECTED CLASSES COMMENTS BODY"));
        dumpFile (editFile (processCreateTests (false, "data|updatemethods|ClassBody", "PUBLIC CLASSES DOC"), "public static Test suite() {", "// added comment in suite method - test for suite method regeneration"));
        dumpFile (processCreateTests (false, "data|updatemethods|ClassBody", "PROTECTED CLASSES DOC DEFAULT"));
        dumpFile (processCreateTests (false, "data|updatemethods|ClassBody", "PACKAGEMETHODS CLASSES DOC SUITE"));
        compareReferenceFiles();
    }
    
    public void testGenerateSuiteFile () {
        dumpFile (editFile (processCreateTests (false, "data|updatesuitefile|Class1", "PUBLIC CLASSES DOC"), "public static Test suite() {", "// added comment in suite method - test for suite method regeneration"));
        dumpFile (processCreateTests (false, "data|updatesuitefile|Class1", "PROTECTED CLASSES DOC"));
        dumpFile (processCreateTests (false, "data|updatesuitefile|Class1", "PACKAGEMETHODS CLASSES DOC SUITE"));
        compareReferenceFiles();
    }
    
    public void testGenerateSuitePackage () {
        NewWizardOperator.create("Java Beans|Java Bean", fs + "|data|updatesuitepackage", "Bean1");
        waitNoNode (processCreateTests (true, "data|updatesuitepackage", "METHODS CLASSES DOC"));
        NewWizardOperator.create("Java Beans|Java Bean", fs + "|data|updatesuitepackage", "Bean2");
        waitNoNode (processCreateTests (true, "data|updatesuitepackage", "METHODS CLASSES DOC"));
        NewWizardOperator.create("Java Beans|Java Bean", fs + "|data|updatesuitepackage", "Bean3");
        dumpFile (processCreateTests (true, "data|updatesuitepackage", "METHODS CLASSES DOC SUITE"));
        NewWizardOperator.create("Java Beans|Java Bean", fs + "|data|updatesuitepackage", "Bean4");
        dumpFile (processCreateTests (true, "data|updatesuitepackage", "METHODS CLASSES DOC"));
        compareReferenceFiles ();
    }
    
    public void testOpenWrong () {
        new JUnitNode (exp.repositoryTab ().tree (), fs + "|data|open").openTest();
        assertErrorDialog ();
        new JUnitNode (exp.repositoryTab ().tree (), fs + "|data|open|Class1").openTest();
        assertErrorDialog ();
    }
    
    public void testOpenPrepare () {
        processCreateTests (new String [] {
            "data|open|opendir",
            "data|open|Class1",
            "data|open|Class2"
        }, "METHODS CLASSES DOC BODY");
        new Node (exp.repositoryTab ().tree (), fs + "|data|open|opendir|OpendirSuite");
        new Node (exp.repositoryTab ().tree (), fs + "|data|open|opendir|Class1Test");
        new Node (exp.repositoryTab ().tree (), fs + "|data|open|Class1Test");
        new Node (exp.repositoryTab ().tree (), fs + "|data|open|Class2Test");
    }
    
    public void testOpenFile () {
        new JUnitNode (exp.repositoryTab ().tree (), fs + "|data|open|Class1").openTest();
        closeEditor ("Class1Test");
        new JUnitNode (exp.repositoryTab ().tree (), fs + "|data|open|Class1Test").openTest();
        closeEditor ("Class1Test");
    }
    
    public void testOpenPackage () {
        new JUnitNode (exp.repositoryTab ().tree (), fs + "|data|open|opendir").openTest();
        closeEditor ("OpendirSuite");
        new JUnitNode (exp.repositoryTab ().tree (), fs + "|data|open|opendir|OpendirSuite").openTest();
        closeEditor ("OpendirSuite");
    }
    
    public void testOpenMany () {
        new OpenTestAction ().performPopup (new Node [] {
            new Node (exp.repositoryTab ().tree (), fs + "|data|open|opendir"),
            new Node (exp.repositoryTab ().tree (), fs + "|data|open|Class1")
        });
        closeEditor ("Class1Test");
        closeEditor ("OpendirSuite");
    }
    
    public void testOpenDeleted () {
        deleteFile (processCreateTests(false, "data|opendeleted|ClassDeleted", "METHODS CLASSES DOC BODY"));
        new JUnitNode (exp.repositoryTab ().tree (), fs + "|data|opendeleted|ClassDeleted");
        assertErrorDialog ();
        deleteFile (processCreateTests(true, "data|opendeleted", "METHODS CLASSES DOC BODY"));
        new JUnitNode (exp.repositoryTab ().tree (), fs + "|data|opendeleted|OpendeletedSuite");
        assertErrorDialog ();
    }

    public void testNewFromTemplate () {
        NewWizardOperator.create("JUnit|Simple JUnit TestCase", fs + "data|nft", "Test1");
        dumpFile ("data|nft|Test1");
        compareReferenceFiles ();
    }
    
    public void testA11Y () {
        new JUnitNode (exp.repositoryTab ().tree (), fs).createTests();
        CreateTestsDialogOperator dia = new CreateTestsDialogOperator ();
        dia.verify ();
        testA11YDialog (dia.getSource (), CREATE_TESTS_DIALOG, false);
        dia.cancel ();
        dia.waitClosed();
        compareReferenceFiles ();
    }
    
    public static final String BUNDLE = "org.netbeans.modules.junit.Bundle";
    
    public static final String GENERATE_COMMENTS = Bundle.getString(BUNDLE, "PROP_body_comments");
    public static final String GENERATE_DEFAULT = Bundle.getString(BUNDLE, "PROP_body_content");
    public static final String GENERATE_JAVADOC = Bundle.getString(BUNDLE, "PROP_javadoc");
    public static final String GENERATE_PACKAGE = Bundle.getString(BUNDLE, "PROP_members_package");
    public static final String GENERATE_PROTECTED = Bundle.getString(BUNDLE, "PROP_members_protected");
    public static final String GENERATE_PUBLIC = Bundle.getString(BUNDLE, "PROP_members_public");
    public static final String INCLUDE_ABSTRACT = Bundle.getString(BUNDLE, "PROP_generate_abstract_impl");
    public static final String INCLUDE_EXCEPTION = Bundle.getString(BUNDLE, "PROP_generate_exception_classes");
    public static final String INCLUDE_PACKAGE_PRIVATE = Bundle.getString(BUNDLE, "PROP_include_package_private_classes");
    public static final String GENERATE_SUITE = Bundle.getString(BUNDLE, "PROP_generate_suite_classes");
    public static final String SHOW_CREATE_DIALOG = Bundle.getString(BUNDLE, "PROP_cfgcreate_enabled");
    public static final String SUITE_CLASS = Bundle.getString(BUNDLE, "PROP_suite_template");
    public static final String TARGET_FS = Bundle.getString(BUNDLE, "PROP_file_system");
    public static final String TEST_CLASS = Bundle.getString(BUNDLE, "PROP_class_template");

    public static final String[] PROPERTIES_TAB_SET_1 = new String[] {
        GENERATE_COMMENTS, GENERATE_DEFAULT, GENERATE_JAVADOC, GENERATE_PACKAGE,
        GENERATE_PROTECTED, GENERATE_PUBLIC, INCLUDE_ABSTRACT, INCLUDE_EXCEPTION,
        INCLUDE_PACKAGE_PRIVATE, GENERATE_SUITE
    };

    public static final String BODY_MAIN = Bundle.getString(BUNDLE, "PROP_generate_main_method_body");
    public static final String EXECUTOR = Bundle.getString(BUNDLE, "PROP_executor_type");
    public static final String GENERATE_MAIN = Bundle.getString(BUNDLE, "PROP_generate_main_method");
    public static final String GENERATE_FOR_TEST_CLASSES = Bundle.getString(BUNDLE, "PROP_generate_test_from_test_classes");
    public static final String PREFIX_SUITE = Bundle.getString(BUNDLE, "PROP_suite_classname_prefix");
    public static final String PREFIX_TEST = Bundle.getString(BUNDLE, "PROP_test_classname_prefix");
    public static final String PROPERTIES_PROP = Bundle.getString(BUNDLE, "PROP_properties");
    public static final String ROOT_SUITE_NAME = Bundle.getString(BUNDLE, "PROP_root_suite_classname");
    public static final String SUFFIX_SUITE = Bundle.getString(BUNDLE, "PROP_suite_classname_suffix");
    public static final String SUFFIX_TEST = Bundle.getString(BUNDLE, "PROP_test_classname_suffix");
    public static final String TEST_RUNNER = Bundle.getString(BUNDLE, "PROP_test_runner");

    public void setStringProperty (PropertySheetTabOperator psto, String prop, String value) {
        new StringProperty (psto, prop).setStringValue(value);
    }
    
    public void setComboProperty (PropertySheetTabOperator psto, String prop, String value) {
        new ComboBoxProperty (psto, prop).setValue(value);
    }
    
    public void testPropertiesInner (PropertySheetTabOperator psto, String prop) {
        for (int a = 0; a < PROPERTIES_TAB_SET_1.length; a ++)
            setComboProperty (psto, PROPERTIES_TAB_SET_1[a], FALSE);
        setComboProperty (psto, prop, TRUE);
        new JUnitNode (exp.repositoryTab().tree (), fs).createTests();
        CreateTestsDialogOperator ctdo = new CreateTestsDialogOperator ();
        ctdo.verify ();
        ctdo.dumpAll (out, fs);
        ctdo.close ();
        ctdo.waitClosed();
    }
    
    public void testProperties () {
        OptionsOperator oo = OptionsOperator.invoke();
        new JUnitNode (oo.treeTable().tree(), TESTING_JUNIT_SETTINGS).properties();
        PropertySheetOperator pso = new PropertySheetOperator (PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, JUNIT_SETTINGS);
        PropertySheetTabOperator psto = new PropertySheetTabOperator (pso, PROPERTIES);
        setComboProperty (psto, TARGET_FS, fs);//CreateTestsDialogOperator.ITEM_NOFILESYSTEMSELECTED);
        setComboProperty (psto, SUITE_CLASS, CreateTestsDialogOperator.ITEM_SIMPLEJUNITTEST);
        setComboProperty (psto, TEST_CLASS, CreateTestsDialogOperator.ITEM_SIMPLEJUNITTEST);
        setComboProperty (psto, SHOW_CREATE_DIALOG, TRUE);
        for (int a = 0; a < PROPERTIES_TAB_SET_1.length; a ++) {
            out.println ("==== Testing property: " + PROPERTIES_TAB_SET_1[a]);
            testPropertiesInner (psto, PROPERTIES_TAB_SET_1[a]);
        }
        compareReferenceFiles ();
    }
    
    public void testExpert () {
        OptionsOperator oo = OptionsOperator.invoke();
        new JUnitNode (oo.treeTable().tree(), TESTING_JUNIT_SETTINGS).properties();
        PropertySheetOperator pso = new PropertySheetOperator (PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, JUNIT_SETTINGS);
        PropertySheetTabOperator psto = new PropertySheetTabOperator (pso, PROPERTIES);
        setComboProperty (psto, TARGET_FS, fs);//CreateTestsDialogOperator.ITEM_NOFILESYSTEMSELECTED);
        setComboProperty (psto, SUITE_CLASS, CreateTestsDialogOperator.ITEM_SIMPLEJUNITTEST);
        setComboProperty (psto, TEST_CLASS, CreateTestsDialogOperator.ITEM_SIMPLEJUNITTEST);
        setComboProperty (psto, SHOW_CREATE_DIALOG, TRUE);
        for (int a = 0; a < PROPERTIES_TAB_SET_1.length; a ++)
            setComboProperty (psto, PROPERTIES_TAB_SET_1[a], TRUE);
        
        psto = new PropertySheetTabOperator (pso, EXPERT);
        setStringProperty(psto, BODY_MAIN, "// This is BODY_MAIN");
        setComboProperty(psto, GENERATE_MAIN, "False");
        setComboProperty(psto, GENERATE_FOR_TEST_CLASSES, "False");
        setStringProperty(psto, PREFIX_SUITE, "PrefixSuite");
        setStringProperty(psto, PREFIX_TEST, "PrefixTest");
        setStringProperty(psto, SUFFIX_SUITE, "SuffixSuite");
        setStringProperty(psto, SUFFIX_TEST, "SuffixTest");
        
        processCreateTests(true, "data|expert", "METHODS CLASSES DOC BODY");
        deleteFile (dumpFile ("data|expert|PrefixSuiteExpertSuffixSuite"));
        deleteFile (dumpFile ("data|expert|PrefixTestClass1SuffixTest"));
        waitNoNode ("data|expert|PrefixTestTestClass1SuffixTest");
        
        psto = new PropertySheetTabOperator (pso, "Expert");
        setStringProperty(psto, BODY_MAIN, "// This is BODY_MAIN");
        setComboProperty(psto, GENERATE_MAIN, "True");
        setComboProperty(psto, GENERATE_FOR_TEST_CLASSES, "True");
        setStringProperty(psto, PREFIX_SUITE, "PrefixSuite2");
        setStringProperty(psto, PREFIX_TEST, "PrefixTest2");
        setStringProperty(psto, SUFFIX_SUITE, "SuffixSuite2");
        setStringProperty(psto, SUFFIX_TEST, "SuffixTest2");
        
        processCreateTests(true, "data|expert", "METHODS CLASSES DOC BODY");
        deleteFile (dumpFile ("data|expert|PrefixSuite2ExpertSuffixSuite2"));
        deleteFile (dumpFile ("data|expert|PrefixTest2Class1SuffixTest2"));
        deleteFile (dumpFile ("data|expert|PrefixTest2TestClass1SuffixTest2"));
        
        compareReferenceFiles ();
    }
    
    public void testRootSuiteClassName () {
        OptionsOperator oo = OptionsOperator.invoke();
        new JUnitNode (oo.treeTable().tree(), TESTING_JUNIT_SETTINGS).properties();
        PropertySheetOperator pso = new PropertySheetOperator (PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, JUNIT_SETTINGS);
        PropertySheetTabOperator psto = new PropertySheetTabOperator (pso, EXPERT);

        setStringProperty(psto, BODY_MAIN, "junit.textui.TestRunner.run(suite());");
        setComboProperty(psto, GENERATE_MAIN, FALSE);
        setComboProperty(psto, GENERATE_FOR_TEST_CLASSES, FALSE);
        setStringProperty(psto, PREFIX_SUITE, "");
        setStringProperty(psto, PREFIX_TEST, "");
        setStringProperty(psto, ROOT_SUITE_NAME, "RootSuiteClassName");
        setStringProperty(psto, SUFFIX_SUITE, SUITE);
        setStringProperty(psto, SUFFIX_TEST, TEST);
        
        String rootfs = fs + File.separator + "data" + File.separator + "root";
        new RepositoryTabOperator ().mountLocalDirectoryAPI(rootfs);
        FilesystemNode rootfsnode = new FilesystemNode (exp.repositoryTab ().tree (), rootfs);
        NewWizardOperator.create(JAVA_BEANS_JAVA_BEAN, rootfsnode.getText() + "|pack", "Bean1");

        new JUnitNode (exp.repositoryTab ().tree (), rootfs).createTests();
        CreateTestsDialogOperator dia = new CreateTestsDialogOperator ();
        dia.verify ();
        processCreateTestsDialogCore (dia, "METHODS CLASSES DOC BODY");
        dia.selectFileSystem(rootfs);
        dia.ok ();
        dia.waitClosed();
        MainWindowOperator.getDefault ().waitStatusText(TEST_CREATED);
        
        dumpFile (rootfs, "RootSuiteClassName");
        dumpFile (rootfs, "pack|Bean1Test");

        rootfsnode.unmount();
        new RepositoryRootNode (exp.repositoryTab().tree ()).waitChildNotPresent(rootfs);
        compareReferenceFiles();
    }
    
    public void testRunPrepare () {
        OptionsOperator oo = OptionsOperator.invoke();
        new JUnitNode (oo.treeTable().tree(), TESTING_JUNIT_SETTINGS).properties();
        PropertySheetOperator pso = new PropertySheetOperator (PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, JUNIT_SETTINGS);
        PropertySheetTabOperator psto = new PropertySheetTabOperator (pso, EXPERT);

        setComboProperty(psto, EXECUTOR, INTERNAL_EXECUTION);
    }
    
    public void testPropertiesProperty () {
        OptionsOperator oo = OptionsOperator.invoke();
        new JUnitNode (oo.treeTable().tree(), TESTING_JUNIT_SETTINGS).properties();
        PropertySheetOperator pso = new PropertySheetOperator (PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, JUNIT_SETTINGS);
        PropertySheetTabOperator psto = new PropertySheetTabOperator (pso, EXPERT);

        setStringProperty(psto, PROPERTIES_PROP, "testingproperty1=testingvalue1oftestingproperty1\na.b.c.d=d.c.b.a\n");
        
        new JUnitNode (exp.repositoryTab().tree (), fs + "|data|run|PropertiesTest").executeTest();
        waitTestExecutionFinished ();
        
        javafilefilter.addReplaceFilter("Elapsed time:", "", "<ELAPSED_TIME>");
        closeTerm (dumpTerm ("Elapsed time:"));
        compareReferenceFiles ();
    }
    
    public void testRunWrong () {
        new JUnitNode (exp.repositoryTab().tree (), fs + "|data|run|NoTest").executeTest();
        assertErrorDialog ();
        new JUnitNode (exp.repositoryTab().tree (), fs + "|data|run").executeTest();
        assertErrorDialog ();
    }
    
    public void testRunClass () {
        new JUnitNode (exp.repositoryTab().tree (), fs + "|data|run|Main").executeTest();
        waitTestExecutionFinished ();
        
        javafilefilter.addReplaceFilter("Elapsed time:", "", "<ELAPSED_TIME>");
        closeTerm (dumpTerm ("Elapsed time:"));
        compareReferenceFiles ();
    }
    
    public void testRunTest () {
        new JUnitNode (exp.repositoryTab().tree (), fs + "|data|run|MainTest").executeTest();
        waitTestExecutionFinished ();
        
        javafilefilter.addReplaceFilter("Elapsed time:", "", "<ELAPSED_TIME>");
        closeTerm (dumpTerm ("Elapsed time:"));
        compareReferenceFiles ();
    }
    
    public void testRunDirectory () {
        new JUnitNode (exp.repositoryTab().tree (), fs + "|data|run|dir").executeTest();
        waitTestExecutionFinished ();
        
        javafilefilter.addReplaceFilter("Elapsed time:", "", "<ELAPSED_TIME>");
        closeTerm (dumpTerm ("Elapsed time:"));

        new JUnitNode (exp.repositoryTab().tree (), fs + "|data|run|dir|DirSuite").executeTest();
        waitTestExecutionFinished ();
        
        javafilefilter.addReplaceFilter("Elapsed time:", "", "<ELAPSED_TIME>");
        closeTerm (dumpTerm ("Elapsed time:"));

        compareReferenceFiles ();
    }
    
    public void testExternalExecution () {
        new RepositoryTabOperator ().mountArchiveFileAPI(System.getProperty ("netbeans.home") + File.separator + "modules" + File.separator + "junit.jar");
        
        OptionsOperator oo = OptionsOperator.invoke();
        new JUnitNode (oo.treeTable().tree(), TESTING_JUNIT_SETTINGS).properties();
        PropertySheetOperator pso = new PropertySheetOperator (PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, JUNIT_SETTINGS);
        PropertySheetTabOperator psto = new PropertySheetTabOperator (pso, EXPERT);

        setComboProperty(psto, EXECUTOR, EXTERNAL_EXECUTION);
	
        new JUnitNode (exp.repositoryTab().tree (), fs + "|data|run|Main").executeTest();
        waitTestExecutionFinished ();
        
        javafilefilter.addReplaceFilter("Elapsed time:", "", "<ELAPSED_TIME>");
        closeTerm (dumpTerm ("Elapsed time:"));
        compareReferenceFiles ();
    }
    
    public void testRunner () {
        OptionsOperator oo = OptionsOperator.invoke();
        new JUnitNode (oo.treeTable().tree(), TESTING_JUNIT_SETTINGS).properties();
        PropertySheetOperator pso = new PropertySheetOperator (PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, JUNIT_SETTINGS);
        PropertySheetTabOperator psto = new PropertySheetTabOperator (pso, EXPERT);
        setStringProperty(psto, TEST_RUNNER, "invalid.class");
        
        new JUnitNode (exp.repositoryTab().tree (), fs + "|data|run|PropertiesTest").executeTest();
        waitTestExecutionFinished ("invalid.class");
        
        TermOperator to = dumpTerm (log, Bundle.getString("org.netbeans.core.execution.Bundle", "CTL_ProgramIO", new Object[] {"invalid.class"}), "invalid/class");
        String totext = to.getText ();
        closeTerm (to);
        
        setStringProperty(psto, TEST_RUNNER, "org.netbeans.modules.junit.testrunner.JUnitTestRunner");

        assertTrue ("\"java.lang.NoClassDefFoundError: invalid/class\" text not found in term output: TOtext: " + totext, totext.indexOf ("java.lang.NoClassDefFoundError: invalid/class") >= 0);
    }
    
    public void testShowCreateDialog () {
        JUnitNode node = new JUnitNode (exp.repositoryTab ().tree (), fs + "|data|showcreate");
        CreateTestsDialogOperator dia;
        OptionsOperator oo = OptionsOperator.invoke();
        new JUnitNode (oo.treeTable().tree(), TESTING_JUNIT_SETTINGS).properties();
        PropertySheetOperator pso = new PropertySheetOperator (PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, JUNIT_SETTINGS);
        PropertySheetTabOperator psto = new PropertySheetTabOperator (pso, PROPERTIES);

        setComboProperty(psto, TARGET_FS, fs);
//        try { Thread.sleep (5000); } catch (InterruptedException e) {}
        log.println ("getTargetFS: " + new ComboBoxProperty (psto, TARGET_FS).getValue());
        setComboProperty(psto, SHOW_CREATE_DIALOG, TRUE);
//        try { Thread.sleep (5000); } catch (InterruptedException e) {}
        node.createTests();
        dia = new CreateTestsDialogOperator ();
        dia.verify ();
        dia.cancel();
        dia.waitClosed();
//        try { Thread.sleep (5000); } catch (InterruptedException e) {}
        
        MainWindowOperator.getDefault().setStatusText("");
        setComboProperty(psto, SHOW_CREATE_DIALOG, FALSE);
//        try { Thread.sleep (5000); } catch (InterruptedException e) {}
        log.println ("getTargetFS: " + new ComboBoxProperty (psto, TARGET_FS).getValue());
        node.createTests();
        MainWindowOperator.getDefault().waitStatusText(TEST_CREATED);
        
        setComboProperty(psto, SHOW_CREATE_DIALOG, TRUE);
        node.createTests();
        dia = new CreateTestsDialogOperator ();
        dia.verify ();
        dia.checkShowCreateTestsConfigurationDialog(false);
        dia.cancel();
        dia.waitClosed();

        MainWindowOperator.getDefault().setStatusText("");
        node.createTests();
        dia = new CreateTestsDialogOperator ();
        dia.verify ();
        dia.checkShowCreateTestsConfigurationDialog(false);
        dia.ok();
        dia.waitClosed();
        MainWindowOperator.getDefault().waitStatusText(TEST_CREATED);
        
        MainWindowOperator.getDefault().setStatusText("");
        node.createTests();
        MainWindowOperator.getDefault().waitStatusText(TEST_CREATED);
    }
    
    public void testTrueFalsePropertyChange (PropertySheetTabOperator producer, PropertySheetTabOperator consumer, String prop) {
        testComboPropertyChange (producer, consumer, prop, new String[] { TRUE, FALSE });
    }
    
    public void testComboPropertyChange (PropertySheetTabOperator producer, PropertySheetTabOperator consumer, String prop, String value) {
        testComboPropertyChange (producer, consumer, prop, new String[] { value });
    }
    
    public void testComboPropertyChange (PropertySheetTabOperator producer, PropertySheetTabOperator consumer, String prop, String[] values) {
        out.println ("==== Comparing property: " + prop);
        ComboBoxProperty p1 = new ComboBoxProperty (producer, prop);
        ComboBoxProperty p2 = new ComboBoxProperty (consumer, prop);
        String previous = p1.getValue ();
        
        for (int a = 0; a < values.length; a ++) {
            String ps = values[a];
            if (ps.equals (fs))
	        ps = "<TARGET_FS>";
            out.println ("     Comparing value: " + ps);
            p1.setValue(values[a]);
            String str = p2.getValue();
            if (!values[a].equals (str))
                out.println ("!!!! ERROR - Expected: " + values[a] + " Got: " + str);
        }
        
        p1.setValue (previous);
    }
    
    public void testStringPropertyChange (PropertySheetTabOperator producer, PropertySheetTabOperator consumer, String prop, String value) {
        out.println ("==== Comparing property: " + prop);
        StringProperty p1 = new StringProperty (producer, prop);
        StringProperty p2 = new StringProperty (consumer, prop);
        String previous = p1.getValue ();
        
        out.println ("     Comparing value: " + value);
        p1.setStringValue(value);
        String str = p2.getValue();
        if (!value.equals (str))
            out.println ("!!!! ERROR - Expected: " + value + " Got: " + str);
        
        p1.setStringValue (previous);
    }
    
    public void testPropertyChanged () {
        OptionsOperator oo = OptionsOperator.invoke();
        new JUnitNode (oo.treeTable().tree(), TESTING_JUNIT_SETTINGS).properties();
        PropertySheetOperator pso1 = new PropertySheetOperator (PropertySheetOperator.MODE_PROPERTIES_OF_ONE_OBJECT, JUNIT_SETTINGS);
        PropertySheetTabOperator psto1p = new PropertySheetTabOperator (pso1, PROPERTIES);

        PropertySheetOperator pso2 = new PropertySheetOperator (oo);
        PropertySheetTabOperator psto2p = new PropertySheetTabOperator (oo, PROPERTIES);

        testTrueFalsePropertyChange(psto1p, psto2p, GENERATE_COMMENTS);
        testTrueFalsePropertyChange(psto1p, psto2p, GENERATE_DEFAULT);
        testTrueFalsePropertyChange(psto1p, psto2p, GENERATE_JAVADOC);
        testTrueFalsePropertyChange(psto1p, psto2p, GENERATE_PACKAGE);
        testTrueFalsePropertyChange(psto1p, psto2p, GENERATE_PROTECTED);
        testTrueFalsePropertyChange(psto1p, psto2p, GENERATE_PUBLIC);
        testTrueFalsePropertyChange(psto1p, psto2p, INCLUDE_ABSTRACT);
        testTrueFalsePropertyChange(psto1p, psto2p, INCLUDE_EXCEPTION);
        testTrueFalsePropertyChange(psto1p, psto2p, INCLUDE_PACKAGE_PRIVATE);
        testTrueFalsePropertyChange(psto1p, psto2p, GENERATE_SUITE);
        testTrueFalsePropertyChange(psto1p, psto2p, SHOW_CREATE_DIALOG);
        testComboPropertyChange(psto1p, psto2p, SUITE_CLASS, "SimpleJUnitTest");
        testComboPropertyChange(psto1p, psto2p, TARGET_FS, fs);//CreateTestsDialogOperator.ITEM_NOFILESYSTEMSELECTED);
        testComboPropertyChange(psto1p, psto2p, TEST_CLASS, "SimpleJUnitTest");

        PropertySheetTabOperator psto1e = new PropertySheetTabOperator (pso1, EXPERT);
        PropertySheetTabOperator psto2e = new PropertySheetTabOperator (oo, EXPERT);

        testStringPropertyChange(psto1e, psto2e, BODY_MAIN, "// Something");
        testComboPropertyChange(psto1e, psto2e, EXECUTOR, new String[] { EXTERNAL_EXECUTION, INTERNAL_EXECUTION});
        testTrueFalsePropertyChange(psto1e, psto2e, GENERATE_MAIN);
        testTrueFalsePropertyChange(psto1e, psto2e, GENERATE_FOR_TEST_CLASSES);
        testStringPropertyChange(psto1e, psto2e, PREFIX_SUITE, "SuitePrefix");
        testStringPropertyChange(psto1e, psto2e, PREFIX_TEST, "TestPrefix");
        testStringPropertyChange(psto1e, psto2e, PROPERTIES_PROP, "Properties=Properties");
        testStringPropertyChange(psto1e, psto2e, ROOT_SUITE_NAME, "SomeRootSuiteClassName");
        testStringPropertyChange(psto1e, psto2e, SUFFIX_SUITE, "SuiteSuffix");
        testStringPropertyChange(psto1e, psto2e, SUFFIX_TEST, "TestSuffix");
        testStringPropertyChange(psto1e, psto2e, TEST_RUNNER, "SomeTestRunner");
        
        compareReferenceFiles ();
    }
    
}
