/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import org.netbeans.mdr.persistence.*;

import java.util.*;

/**
 * JdbcCollection is a read-only Collection backed by queries.
 *
 * @author John V. Sichi
 * @version $Id: JdbcCollection.java,v 1.1.106.1 2006/07/01 05:19:20 jtulach Exp $
 */
class JdbcCollection extends AbstractCollection
{
    // delegate to JdbcSet for everything
    private JdbcSet set;

    JdbcCollection(
        JdbcStorage storage,
        Storage.EntryType entryType,
        LazyPreparedStatement sqlIterator,
        LazyPreparedStatement sqlSize,
        LazyPreparedStatement sqlContains)
    {
        set = new JdbcSet(storage,entryType,sqlIterator,sqlSize,sqlContains);
    }

    // override AbstractSet
    public boolean contains(Object obj)
    {
        return set.contains(obj);
    }
    
    // implement AbstractCollection
    public Iterator iterator()
    {
        return set.iterator();
    }

    // implement AbstractCollection
    public int size()
    {
        return set.size();
    }
}

// End JdbcCollection.java
