/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import org.netbeans.mdr.persistence.*;

import java.util.*;

/**
 * JdbcSet is a read-only Set backed by queries.
 *
 * @author John V. Sichi
 * @version $Id: JdbcSet.java,v 1.1.106.1 2006/07/01 05:19:21 jtulach Exp $
 */
class JdbcSet extends AbstractSet
{
    private final JdbcStorage storage;
    private final Storage.EntryType entryType;
    private final LazyPreparedStatement sqlIterator;
    private final LazyPreparedStatement sqlSize;
    private final LazyPreparedStatement sqlContains;

    JdbcSet(
        JdbcStorage storage,
        Storage.EntryType entryType,
        LazyPreparedStatement sqlIterator,
        LazyPreparedStatement sqlSize,
        LazyPreparedStatement sqlContains)
    {
        this.storage = storage;
        this.entryType = entryType;
        this.sqlIterator = sqlIterator;
        this.sqlSize = sqlSize;
        this.sqlContains = sqlContains;
    }

    // implement AbstractSet
    public Iterator iterator()
    {
        try {
            return storage.getResultSetIterator(sqlIterator,null,entryType);
        } catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }

    // override AbstractSet
    public boolean contains(Object obj)
    {
        try {
            int n = storage.getSingletonInt(
                sqlContains,new Object[]{obj});
            return n > 0;
        } catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }

    // implement AbstractSet
    public int size()
    {
        try {
            if (sqlSize != null) {
                return storage.getSingletonInt(sqlSize,null);
            } else {
                // this could be used to compensate for a DBMS without
                // COUNT(DISTINCT)
                return storage.getResultSetCount(sqlIterator,null);
            }
        } catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }
}

// End JdbcSet.java
