/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import org.netbeans.mdr.persistence.*;
import java.sql.*;
import java.io.*;

/**
 * This is thrown to wrap an SQLException as a StorageException.
 *
 * @author John V. Sichi
 * @version $Id: JdbcStorageException.java,v 1.2.98.1 2006/07/01 05:19:22 jtulach Exp $
 *
 * @see StorageIOException
 */
public class JdbcStorageException extends StorageBadRequestException
{
    /**
     * The original SQLException that we are converting to a StorageException.
     */
    private SQLException sqlException;

    /** this constructs a JdbcStorageException from an SQLException
    * @param err the SQLException
    */
    public JdbcStorageException(SQLException err)
    {
        super(err.getMessage());
        sqlException = err;
    }

    /** return the original SQLException's message */
    public String getMessage()
    {
        return sqlException.getMessage();
    }
	
    /** return the original SQLException's localized message */
    public String getLocalizedMessage()
    {
        return sqlException.getLocalizedMessage();
    }

    /** print the original SQLException's stack trace */
    public void printStackTrace()
    {
        sqlException.printStackTrace();
    }

    /** print the original SQLException's stack trace */
    public void printStackTrace(PrintStream ps)
    {
        sqlException.printStackTrace(ps);
    }

    /** print the original SQLException's stack trace */
    public void printStackTrace(PrintWriter pw)
    {
        sqlException.printStackTrace(pw);
    }

    /** get the original SQLException's cause */
    public Throwable getCause()
    {
        return sqlException.getNextException();
    }
}

// End JdbcStorageException.java
