/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import org.netbeans.mdr.persistence.*;

import java.sql.*;
import java.util.*;

/**
 * JdbcStorageFactory implements the StorageFactory interface by
 * creating instances of JdbcStorage.
 *
 * @author John V. Sichi
 * @version $Id: JdbcStorageFactory.java,v 1.4.40.1.2.1 2006/07/01 05:19:22 jtulach Exp $
 */
public class JdbcStorageFactory implements StorageFactory
{
    // NOTE: Property names are defined here without the MDRStorageProperty
    // prefix; user code should prepend that prefix, which will be stripped off
    // by MDR before createStorage is called.
    
    public static final String PROPERTY_PREFIX =
    "org.netbeans.mdr.persistence.jdbcimpl.";
    
    public static final String STORAGE_URL =
    PROPERTY_PREFIX + "url";
    
    public static final String STORAGE_SCHEMA_NAME =
    PROPERTY_PREFIX + "schemaName";

    public static final String STORAGE_USER_NAME =
    PROPERTY_PREFIX + "userName";

    public static final String STORAGE_SCHEMA_AUTH_NAME =
    PROPERTY_PREFIX + "schemaAuthName";

    public static final String STORAGE_PASSWORD =
    PROPERTY_PREFIX + "password";

    public static final String STORAGE_DRIVER_CLASS_NAME =
    PROPERTY_PREFIX + "driverClassName";

    public static final String STORAGE_FIRST_SERIAL_NUMBER =
    PROPERTY_PREFIX + "firstSerialNumber";
    
    public static final String STORAGE_DEBUG_PRINT =
    PROPERTY_PREFIX + "debugPrint";
    
    public static final String STORAGE_QUERY_DUPLICATES =
    PROPERTY_PREFIX + "queryDuplicates";
    
    public static final String STORAGE_DATATYPE_MOFID =
    PROPERTY_PREFIX + "datatype.mofid";

    public static final String STORAGE_DATATYPE_STREAMABLE =
    PROPERTY_PREFIX + "datatype.streamable";

    public static final String STORAGE_DATATYPE_STRING =
    PROPERTY_PREFIX + "datatype.string";

    public static final String STORAGE_DATATYPE_INT =
    PROPERTY_PREFIX + "datatype.int";

    // adapted from memoryimpl
    private static final String NULL_STORAGE_ID = "j";
    private static final MOFID NULL_MOFID = new MOFID(0, NULL_STORAGE_ID);
    
    // implement StorageFactory
    public Storage createStorage(Map map) throws StorageException
    {
        Properties properties = new Properties();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            if (!(entry.getKey() instanceof String)) {
                continue;
            }
            if (entry.getValue() == null) {
                continue;
            }
            if (!(entry.getValue() instanceof String)) {
                continue;
            }
            properties.put(entry.getKey(),entry.getValue());
        }
        String url = properties.getProperty(STORAGE_URL);
        String schemaName = properties.getProperty(STORAGE_SCHEMA_NAME);
        String driverClassName =
            properties.getProperty(STORAGE_DRIVER_CLASS_NAME);
        if (url == null || schemaName == null) {
            throw new StorageBadRequestException(
                "JdbcStorageFactory requires parameters "
                + STORAGE_URL + " and " + STORAGE_SCHEMA_NAME);
        }
        if (driverClassName != null) {
            try {
                Class.forName(driverClassName);
            } catch (ClassNotFoundException ex) {
                // let driver manager report "no suitable driver" when
                // the connection is attempted
            }
        }
        return new JdbcStorage(properties,NULL_STORAGE_ID);
    }
    
    // implement StorageFactory
    public MOFID createNullMOFID() throws StorageException
    {
        return NULL_MOFID;
    }
}

// End JdbcStorageFactory.java
