/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdrant;

import java.util.Iterator;

import org.apache.tools.ant.BuildException;

import javax.jmi.model.MofPackage;
import javax.jmi.model.ModelPackage;

/** Instantiates metamodel into given extent.
 *
 * @author  Petr Hrebejk
 */
public class Instantiate extends MdrTask.Sub {
    
    private String name;
    private String extent;
    private String packageName;
    
    /** Creates a new instance of PrintExtentsNames */
    public Instantiate() {
    }
    
    public void execute() throws Exception {
        
        if ( name == null ) {
            throw new BuildException( "Name for newly instantiated package has to be sppecified. Use the \"name\" attribute" );
        }
        
        if ( extent == null && packageName == null ) {
            getRepository().createExtent( name );
        }
        else {
            if ( extent == null ) {
                throw new BuildException( "Extent containing the package has to be specified. Use the \"extent\" attribute" );
            }
            if ( packageName == null ) {
                throw new BuildException( "The package has to be specified. Use the \"package\" attribute" );
            }
            
            MofPackage mp = getModelPackage();
            
            if ( mp == null ) {
                throw new BuildException( packageName + " does not exist in extent " + extent );
            }
            
            getRepository().createExtent( name, mp ); 
        }
        
    }
    
    // ANT task attributes -----------------------------------------------------
    
    public void setName( String name ) {
        this.name = name;
    }
    
    public void setExtent( String extent ) {
        this.extent = extent;
    }
    
    public void setPackage( String packageName ) {
        this.packageName = packageName;
    }
    
    // private methods ---------------------------------------------------------
    
    
    private MofPackage getModelPackage() {
        
        ModelPackage mofPackage = (ModelPackage)getRepository().getExtent( extent );
        MofPackage result;
        
        for (Iterator it = mofPackage.getMofPackage().refAllOfClass().iterator(); it.hasNext();) {
            result = (MofPackage) it.next();
            if (result.getName().equals( packageName )) {
                return result;
            }
        }
        
        return null;
    }
    
    
}
