/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdrant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;

import javax.jmi.reflect.*;

import org.apache.tools.ant.BuildException;

import org.netbeans.api.mdr.*;
import org.netbeans.lib.jmi.mapping.FileStreamFactory;
import org.netbeans.lib.jmi.mapping.JMIMapperImpl;

/** Creates JMI maping in form of source files.
 *
 * @author  Petr Hrebejk
 */
public class MapJava extends MdrTask.Sub {
    
    private File dir; 
    private File headerFile;
    private String extent; 
    
    /** Creates a new instance of PrintExtentsNames */
    public MapJava() {
    }
    
    public void execute() throws Exception {
        
        if ( dir == null ) {
            throw new BuildException( "Destination directory has to be sppecified. Use the \"dir\" attribute" );
        }
        
        if ( extent == null ) {
            throw new BuildException( "Extent to map has to be sppecified. Use the \"extent\" attribute" );
        }
        
        JMIStreamFactory streamFactory = new FileStreamFactory( dir );
        
        getMapper().generate( streamFactory, getRepository().getExtent( extent ) );
        
    }
    
    // ANT task attributes -----------------------------------------------------
    
    public void setDir( File dir ) {
      this.dir = dir;
    }
    
    public void setExtent( String extent ) {
        this.extent = extent;
    }
    
    public void setHeaderFile(File headerFile) {
        this.headerFile = headerFile;
    }
    
    // Protected methods -------------------------------------------------------
    
    protected JMIMapper getMapper() throws IOException {
        JMIMapperImpl result = new JMIMapperImpl();
        if (headerFile != null) {
            BufferedReader reader = new BufferedReader(new FileReader(headerFile));
            StringWriter header = new StringWriter();
            int ch;
            while ((ch = reader.read()) != -1) {
                header.write(ch);
            }
            reader.close();
            header.close();
            result.setHeader(header.toString());
        }
        return result;
    }
    
    
}
