/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdrant;

import java.util.ArrayList;
import java.util.Iterator;

import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;

import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;
import org.openide.util.lookup.Lookups;

import org.netbeans.api.mdr.*;
import org.netbeans.mdr.NBMDRManagerImpl;
import org.netbeans.lib.jmi.xmi.*;
import org.netbeans.lib.jmi.mapping.JMIMapperImpl;

/** Main task for working with MDR. Specifies the repository to work
 *  on.
 *
 * @author  Petr Hrebejk
 */
public class MdrTask extends Task {

    static MdrTask currentTask;
        
    // List of subtasks to be executed
    private ArrayList subtasks;
    
    // Where the storage files reside
    private String storageFile;
    
    // The repository to work on
    MDRepository mdr;
    
        
    /** Creates a new instance of Main */
    public MdrTask() {
        subtasks = new ArrayList();
    }
        
    // Implementation of Ant Task ----------------------------------------------

    /** Executes all subtasks
     */
    public void execute() throws BuildException {

        // integrate logging between MDR and ant
        MdrantLogger.setTask(this);

        // wrap all MDR access in try/catch since methods like beginTrans
        // can throw exceptions
        try {
            MDRManager mm = funnyClassLoaders(); // Beautiful hack to make the
            // NetBeans lookup work        
            mdr = mm.getDefaultRepository();
                
                
            for( Iterator it = subtasks.iterator(); it.hasNext(); ) {
                Sub subtask = (Sub)it.next();

                // beginTrans outside of try since beginTrans failure shouldn't
                // be rolled back
                mdr.beginTrans( true ); // Each subtask runs in it's own trans.
                boolean rollback = true;
                try {
                    subtask.execute();
                    rollback = false;
                }
                finally {
                    if ( rollback ) {
                        // Exception => Rollback transaction
                        mdr.endTrans( true );
                    }
                }
                mdr.endTrans( false ); // OK => Commit transaction
            }               
        
            mm.shutdownAll();
        } catch ( Throwable t ) {
            t.printStackTrace();
            throw new BuildException(t);
        } finally {
            MdrantLogger.setTask(null);
        }
    }
    
    /** Initializes the repository.
     */
    public void init() throws BuildException {          
                
        
    }
    
    // ANT task attributes -----------------------------------------------------
    
    public void setStorageFile( String storageFile ) {
        this.storageFile = storageFile;
    }
                              
    // Creation and addition of subtasks ---------------------------------------
    
        
    public PrintExtentNames createPrintExtentNames( ) {
        return new PrintExtentNames();
    }
    
    public void addPrintExtentNames( PrintExtentNames subtask ) {
        subtask.setTask( this );
        subtasks.add( subtask );
    }
    
    public Instantiate createInstantiate( ) {
        return new Instantiate();
    }
    
    public void addInstantiate( Instantiate subtask ) {
        subtask.setTask( this );
        subtasks.add( subtask );
    }
    
    public ReadXMI createReadXMI( ) {
        return new ReadXMI();
    }
    
    public void addReadXMI( ReadXMI subtask ) {
        subtask.setTask( this );
        subtasks.add( subtask );
    }
    
    public WriteXMI createWriteXMI( ) {
        return new WriteXMI();
    }
    
    public void addWriteXMI( WriteXMI subtask ) {
        subtask.setTask( this );
        subtasks.add( subtask );
    }
    
    
    public WriteDTD createWriteDTD( ) {
        return new WriteDTD();
    }
    
    public void addWriteDTD( WriteDTD subtask ) {
        subtask.setTask( this );
        subtasks.add( subtask );
    }
    
    public MapJava createMapJava( ) {
        return new MapJava();
    }
    
    public void addMapJava( MapJava subtask ) {
        subtask.setTask( this );
        subtasks.add( subtask );
    }
    
    public MapClass createMapClass( ) {
        return new MapClass();
    }
    
    public void addMapClass( MapClass subtask ) {
        subtask.setTask( this );
        subtasks.add( subtask );
    }
            
    // Public innerclasses -----------------------------------------------------
    
    public static abstract class Sub {
    
        protected MdrTask task;
            
        public Sub() {
        }

        void setTask( MdrTask task ) {
            this.task = task;
        }
        
        public abstract void execute() throws Exception;
        
        public final MDRepository getRepository() {
            return task.mdr;
        }
    }
    
    // private methods ---------------------------------------------------------
    
    private MDRManager funnyClassLoaders() {
        
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();                
        Thread.currentThread().setContextClassLoader( this.getClass().getClassLoader() );
                
        if ( storageFile != null ) {
            System.getProperties().put( "org.netbeans.mdr.persistence.Dir", storageFile );
        }
        
        MDRManager mm = MDRManager.getDefault();
        
        Thread.currentThread().setContextClassLoader( oldLoader );
        
        return mm;
    }
        
    
    // For testing purposes only -----------------------------------------------
    
    public static void main( String args[] ) {
        
        MdrTask mt = new MdrTask();
        mt.execute();
        
    }
    
}
    
