/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdrant;

import java.io.*;
import java.util.*;
import org.openide.ErrorManager;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

/**
 * Logger which forwards MDR notifications to Ant.
 *
 * @author John V. Sichi
 */
public class MdrantLogger extends ErrorManager
{
    private static Task task;
    
    public MdrantLogger()
    {
    }

    static void setTask(Task newTask)
    {
        task = newTask;
    }

    // implement ErrorManager
    public Throwable attachAnnotations(
        Throwable t, Annotation[] arr)
    {
        return t;
    }
        
    // implement ErrorManager
    public Annotation[] findAnnotations(Throwable t)
    {
        return null;
    }
        
    // implement ErrorManager
    public Throwable annotate(
        Throwable t, int severity,
        String message, String localizedMessage,
        Throwable stackTrace, java.util.Date date)
    {
        if (task != null) {
            task.log(message, convertSeverity(severity));
        }
        return t;
    }
        
    // implement ErrorManager
    public void notify(int severity, Throwable t)
    {
        if (task != null) {
            task.log(t.toString(), convertSeverity(severity));
        }
    }
        
    // implement ErrorManager
    public void log(int severity, String s)
    {
        if (task != null) {
            task.log(s, convertSeverity(severity));
        }
    }
        
    // implement ErrorManager
    public ErrorManager getInstance(String name)
    {
        return this;
    }
    
    private static int convertSeverity(int severity)
    {
        switch(severity) {
        case INFORMATIONAL:
            return Project.MSG_VERBOSE;
        case WARNING:
            return Project.MSG_WARN;
        case USER:
            return Project.MSG_INFO;
        case EXCEPTION:
            return Project.MSG_ERR;
        case ERROR:
            return Project.MSG_ERR;
        default:
            return Project.MSG_DEBUG;
        }
    }
}

// End MdrantLogger.java
