/**
  * The contents of this file are subject to the terms of the Common Development
  * and Distribution License (the License). You may not use this file except in
  * compliance with the License.
  *
  * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
  * or http://www.netbeans.org/cddl.txt.
  * 
  * When distributing Covered Code, include this CDDL Header Notice in each file
  * and include the License file at http://www.netbeans.org/cddl.txt.
  * If applicable, add the following below the CDDL Header, with the fields
  * enclosed by brackets [] replaced by your own identifying information:
  * "Portions Copyrighted [year] [name of copyright owner]"
  *
  * The Original Software is NetBeans.
  * The Initial Developer of the Original Software is Adaptive Inc.
  * Portions created by Sun Microsystems, Inc. are Copyright (C) 2003 Sun
  * Microsystems, Inc. All Rights Reserved.
  *
  * Contributor(s): Nick Dowler.
  */

package org.netbeans.lib.jmi.uml2mof.servlet;

import java.util.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.fileupload.*;
import java.util.Iterator;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.xmi.XmiReader;
import javax.jmi.xmi.XmiWriter;

import org.netbeans.api.mdr.CreationFailedException;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.lib.jmi.uml2mof.Transformer;
import org.omg.uml.UmlPackage;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public class TransformServlet extends HttpServlet {

    private static final String MOF_INSTANCE = "MOFInstance";
    private static final String UML_INSTANCE = "UMLInstance";
    private static final String UML_MM = "UML";
    private static final String TRANSFORM_IN_PROGRESS = "<meta http-equiv=\"refresh\" content=\"0;url='TransformServlet'\"/><html><body><font size=\"medium\">Please wait! Transforming UML 1.4 to MOF 1.4...</font></body></html>";
    private static final String NOTHING_TO_TRANSFORM = "There is no file on the session to transform";
    
    private String fileStore;
    private FileUpload fu;
    
    class TransformInfo {
    	  TransformInfo(FileItem fi) { this.fi = fi; }
    	  public FileItem getFileItem() { return fi; }
        private FileItem fi; 
    }
    
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    	  try {
            fu = new FileUpload();
            // maximum size before a FileUploadException will be thrown
            Integer maxFileSize = new Integer(config.getInitParameter("maxFileSize"));
            fu.setSizeMax(maxFileSize.intValue());
            // maximum size that will be stored in memory
            Integer maxMemSize = new Integer(config.getInitParameter("maxMemSize"));
            fu.setSizeThreshold(maxMemSize.intValue());
            // the location for saving data that is larger than getSizeThreshold()
            fileStore = config.getInitParameter("fileStore");
            fu.setRepositoryPath(fileStore);
            // set up mdrepository to use in memory storage
            System.setProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName", "org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl");
    	  } catch (Exception cfe) {
        	throw new ServletException(cfe);
        }
    }
    
    private MofPackage getUmlPackage(MDRepository rep) throws Exception {
        ModelPackage umlMM = (ModelPackage) rep.getExtent(UML_MM);
        if (umlMM == null) {
            umlMM = (ModelPackage) rep.createExtent(UML_MM);
        }
        MofPackage result = getUmlPackage(umlMM);
        if (result == null) {
        	  XmiReader reader = (XmiReader)Lookup.getDefault().lookup(XmiReader.class);
            reader.read(UmlPackage.class.getResource("resources/01-02-15_Diff.xml").toString(), umlMM);
        }
        result = getUmlPackage(umlMM);
        return result;
    }
    
    private MofPackage getUmlPackage(ModelPackage umlMM) {
        for (Iterator it = umlMM.getMofPackage().refAllOfClass().iterator(); it.hasNext();) {
            MofPackage pkg = (MofPackage) it.next();
            if (pkg.getContainer() == null && "UML".equals(pkg.getName())) {
                return pkg;
            }
        }
        return null;
    }

    private String formatException(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return e.toString() + "\n" + sw.toString();
    }
    
    private void doTransform(FileItem fi, OutputStream out) throws Exception {
        XmiReader reader = (XmiReader)Lookup.getDefault().lookup(XmiReader.class);
        XmiWriter writer = (XmiWriter)Lookup.getDefault().lookup(XmiWriter.class);
        MDRepository rep = MDRManager.getDefault().getDefaultRepository();
        rep.beginTrans(true);
        try {
            ModelPackage mof = (ModelPackage) rep.getExtent(MOF_INSTANCE);
            UmlPackage uml = (UmlPackage) rep.getExtent(UML_INSTANCE);
            if (mof == null) {
                mof = (ModelPackage)rep.createExtent(MOF_INSTANCE);
            }
            if (uml == null) {
                uml = (UmlPackage)rep.createExtent(UML_INSTANCE, getUmlPackage(rep));
            }
            reader.read(fi.getInputStream(), "", uml);
            Transformer.execute(uml, mof);
            writer.write(out, mof, null);
         } finally {
            rep.endTrans(true);
         }
    }
    
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException
    {
        try {
        	  HttpSession session = req.getSession();
        	  TransformInfo ti = (TransformInfo)session.getAttribute("transform");
        	  if (ti != null) {
        	  	  try {
                    FileItem fi = ti.getFileItem();
                    doTransform(fi, res.getOutputStream());
                    res.setContentType(fi.getContentType());
                    res.setHeader("Content-Disposition", "inline;filename=" + fi.getName());
        	  	  } finally {
        	  	      session.setAttribute("transform", null);
        	  	  }
            } else {
            	  res.getWriter().println(NOTHING_TO_TRANSFORM);
        	  }
        } catch (Exception e) {
            throw new ServletException(e);
        }
     }	

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException
    {
        try {
        	  HttpSession session = req.getSession();
        	  TransformInfo ti = (TransformInfo)session.getAttribute("transform");
        	  if (ti == null) {
                List fileItems = fu.parseRequest(req);
                Iterator i = fileItems.iterator();
                String redirect = null;
                while (i.hasNext()) {
                	  FileItem fi = (FileItem)i.next();
                	  if ("umlfile".equals(fi.getFieldName()) && ti == null) {
            				    ti = new TransformInfo(fi);
            				    session.setAttribute("transform", ti);
                	  }
                	  if ("redirect".equals(fi.getFieldName()) && redirect == null)
            				    redirect = fi.getString();                	      
                }
     				    if (redirect != null)
     				        res.sendRedirect(res.encodeRedirectURL(redirect));
            } else {
            	PrintWriter out = res.getWriter();
            	out.println(TRANSFORM_IN_PROGRESS);
        	  }
        } catch (Exception e) {
            try {
                (res.getWriter()).println(formatException(e));
            } catch (Exception n) {
            	throw new ServletException(n);
            }
        }
     }	
}
