/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.mapping;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.api.mdr.*;
import javax.jmi.reflect.RefBaseObject;
import java.io.*;

/**
 *
 * @author  mm109185
 */
public class JMIMapperImpl extends JMIMapper implements Serializable {
    
    /** name of property mapper header */
    public static final String PROP_HEADER = "header"; //NOI18N
    
    /** listeners support */
    private transient PropertyChangeSupport supp;
    
    private String header = "";
    
    // init ......................................................................
    
    /** Creates new JMIMapperImpl */
    public JMIMapperImpl() {
    }

    // methods ...................................................................
    
    public String getHeader () {
        return header;        
    }
    
    public void setHeader (String header) {
        String oldHeader = this.header;
        if (!oldHeader.equals(header)) {
            this.header = header;
            init();
            supp.firePropertyChange(PROP_HEADER, oldHeader, header);
        }
    }
        
    public void generate(JMIStreamFactory sf, RefBaseObject object) throws IOException {
        new JavaMapper(sf, header).visitRefBaseObject(object);
    }

    /** Add a property change listener.
    * @param l the listener to add
    */
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        init();
        supp.addPropertyChangeListener(l);
    }

    /** Remove a property change listener.
    * @param l the listener to remove
    */
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (supp != null) supp.removePropertyChangeListener(l);
    }
    
    private synchronized void init() {
        if (supp == null) {
            supp = new PropertyChangeSupport(this);        
        }
    }
}
